/*
  sm_Node.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Node_H
#define sm_Node_H

#include <stdio.h>

#include "mt_Node.h"
#include "sm_Port.h"
#include "mt_Job.h"

class sm_Node: public mt_Node, public sm_Callable
{
  protected:
  mt_Job*job;  
  sm_Simulator*simulator;

  public:

  enum
  {
    TIME_FOR_BYTE = 7
  };
  
  sm_Node (char*name, char*type);
  ~sm_Node ();

  virtual void simpleDump (FILE*fp, sm_Time simulationTime);

  virtual int isNull () = 0;
  
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void disconnect (int p);
  
  virtual sm_Port*getInput (int p) = 0;
  virtual sm_Port*getOutput (int p) = 0;
  virtual void definePort (int p, int inSize, int outSize, int timeForByte) = 0;

  void setJob (mt_Job*job);
  mt_Job*getJob ();
  void setSimulator (sm_Simulator*simulator);
};

#endif /*sm_Node_H*/
