/*
  sm_Node.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "sm_Node.h"

sm_Node::sm_Node (char*name, char*type): mt_Node (name, type)
{
  job = 0;
  simulator = 0;
}

sm_Node::~sm_Node ()
{
}

mt_Node*sm_Node::getNode (int p)
{
  insist (this);
  sm_Port*t;
  t = getOutput (p)->getNext();
  if (t)
  {
    sm_Node*n = t->getNode ();
    return n->isNull() ? 0 : n;
  }
  exception: return 0;
}

int sm_Node::getOpposite (int p)
{
  insist (this);
  sm_Port*t;
  t = getOutput (p)->getNext ();
  if (t) return t->getPort();
  exception: return -1;
}

void sm_Node::connect (int p, int o, mt_Node*n) 
{
  sm_Node*s = (sm_Node*)n;
  
  insist (this);
  insist (s->getInput (o) && s->getOutput (o));
  insist (getInput (p) && getOutput (p));
    
  getOutput (p)->setNext (s->getInput (o));
  s->getOutput (o)->setNext (getInput (p));
  exception: return;
}

void sm_Node::disconnect (int p) 
{
  insist (this);
  insist (getInput (p) && getOutput (p));
    
  getOutput (p)->setNext (0);
  
  exception: return;
}


void sm_Node::simpleDump (FILE*fp, sm_Time simulationTime)
{
  insist (this);
  insist (fp);
  
  int numNodes;
  numNodes = getNumNodes ();
  int maxNodes;
  maxNodes = getMaxNodes ();
  
  fprintf (fp, "%s \"%s\" %d\n", isHost () ? "h" : "s", getName (), numNodes);
  
  for (int i = 0; i < maxNodes; i++)
  {
    if (!getNode (i))
      continue;

    sm_Time utilizedTime = getOutput (i)->getTimeUtilized();
    double utilization = ((double)utilizedTime)/((double)simulationTime);

    fprintf (fp,"%d %5.3f (%d)\n", i, utilization, getOutput (i)->getNumPackets ());
  } 
  fprintf (fp, "\n");
  exception: return;
}



mt_Job*sm_Node::getJob ()
{
  insist (this);
  return job;
  exception: return 0;
}

void sm_Node::setJob (mt_Job*job)
{
  insist (this);
  insist (job);
  
  this->job = job;
  
  exception: return;
}

void sm_Node::setSimulator (sm_Simulator*simulator)
{
  insist (this);
  insist (simulator);
  this->simulator = simulator;
  exception: return;
}
