/*
  sm_Host.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Host_h
#define sm_Host_h

#include "sm_Node.h"
#include "mt_Queue.h"
#include "mt_Route.h"

class sm_Simulator;

class sm_Host: public sm_Node
{
  private:
  int gmId;
  int hostType;
  sm_Port input;
  sm_Port output;
  mt_Queue sendQueue;
  mt_Queue receiveQueue;
  int numDrops;
  int queueLatency;
  int dropCount;
  int neverSend;
  int neverReceive;
  sm_Time sleepTime;
  mt_Address address;
  int replyOption;
  
  int send (sm_EventList*list);
  void notifyJob (int event, char*p = 0, int length = 0);
  
  public:
  
  sm_Host (char*name, char*type, int queueSize, int queueLatency);
  int getNeverSend ();
  int getNeverReceive ();
  int addSleepTime (sm_Time sleepTime);
  sm_Time getSleepTime ();
  virtual int getReplyOption ();
  
  virtual ~sm_Host ();
  virtual sm_Time getTimeUtilized ();
  virtual int isNull ();
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual int getHostType ();
  virtual int getGmId ();
  virtual mt_Address*getAddress ();
  virtual void setAddress (mt_Address*address);

  virtual int setOption (char*option, char*value);
  virtual int send (sm_EventList*list, mt_Route*route, char*p,
		    int dataLength, int totalLength);
  virtual sm_Port*getInput (int i);
  virtual sm_Port*getOutput (int i);
  virtual void definePort (int i, int inSize, int outSize, int timeForByte);
  virtual void call (sm_EventList*list, int type, long data);
};

#endif /*sm_Host_h*/
