/*
  sm_Graph.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "sm_Graph.h"
#include "sm_Host.h"
#include "sm_Switch.h"
#include "sm_Packet.h"
#include "sm_Cloud.h"

sm_Graph::sm_Graph (int queueSize, int queueLatency,int switchInSize,int switchOutSize, int switchTimeForByte)
{
  this->queueSize = queueSize;
  this->queueLatency = queueLatency;
  this->hostDropPeriod = hostDropPeriod;
  this->hostDelay = hostDelay;
  this->switchInSize = switchInSize;
  this->switchOutSize = switchOutSize;
  this->switchTimeForByte = switchTimeForByte;
}

mt_Node*sm_Graph::newNode (int nodeType, char*name, char*type)
{
  insist (this);
  switch (nodeType)
  {
    case mt_Node::HOST:
      return new sm_Host (name, type, queueSize, queueLatency);
    case mt_Node::SWITCH:
      return new sm_Switch (name, type, switchInSize, switchOutSize, switchTimeForByte);
    case mt_Node::CLOUD:
      return new sm_Cloud (name, type, queueSize, queueLatency);
    default:
      insist (0);
  }
  exception: return 0;
}

void sm_Graph::dumpPackets (FILE*fp)
{
  insist (this);
  insist (fp);

  int numNodes;
  numNodes = getNumNodes ();
  
  for (int i = 0; i < numNodes; i++)
  {
    sm_Node*node = (sm_Node*) getNode (i);
    
    insist (node);
    
    int numPorts = node->getMaxNodes ();
    insist (numPorts >= 0);
    
    for (int j = 0; j < numPorts; j++)
    { 
      sm_Port*port = node->getInput (j);
      insist (port);
      if (port->getPacket ())
	port->getPacket()->dumpChain (fp);
      if (port->getNextInLine ())
	port->getNextInLine ()->dumpChain (fp);
      
      port = node->getOutput (j);
      insist (port);
      if (port->getPacket ())
	port->getPacket()->dumpChain (fp);
      if (port->getNextInLine ())
	port->getNextInLine ()->dumpChain (fp);
      
    }
  }
  exception: return;
}

