/*
  sm_Cloud.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Cloud_h
#define sm_Cloud_h

#include "sm_Node.h"
#include "mt_Queue.h"
#include "mt_Route.h"

class sm_Simulator;

class sm_Cloud: public sm_Node
{
  private:
  sm_Port*inputs;
  sm_Port*outputs;
  mt_Queue sendQueue;
  mt_Queue receiveQueue;
  int numNodes;
  int numDrops;
  int queueLatency;
  mt_Address address;
  
  int send (sm_EventList*list);
  void notifyJob (int event, char*p = 0, int length = 0);
  
  public:
  
  sm_Cloud (char*name, char*type, int queueSize, int queueLatency);

  virtual ~sm_Cloud ();
  virtual sm_Time getTimeUtilized ();
  virtual int isNull ();
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Address*getAddress ();
  virtual void setAddress (mt_Address*address);
  virtual int setOption (char*option, char*value);
  virtual int send (sm_EventList*list, mt_Route*route, char*p,
		    int dataLength, int totalLength);
  virtual sm_Port*getInput (int i);
  virtual sm_Port*getOutput (int i);
  virtual void definePort (int i, int inSize, int outSize, int timeForByte);
  virtual void call (sm_EventList*list, int type, long data);
};

#endif /*sm_Cloud_h*/
