/*
  sm_Callable.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Callable_h
#define sm_Callable_h

#ifndef sm_EventList_h
#include "sm_EventList.h"
#endif

class sm_Callable
{
  private:
  sm_Event *cHead;
  int numEvents;
  
  public:
  sm_Callable();
  int check();

  virtual void call (sm_EventList*list, int type, long data) = 0;

  void addEvent(sm_EventList *list, sm_Time delta, int type, long data);
  void extractEvent(sm_EventList *list, sm_Event *e);
  int hasEvent (sm_EventList*list, int type);
  void removeAllEvents(sm_EventList *list);
  void removeEventsOfType(sm_EventList *list, int type);
};


#endif /*sm_Callable_h*/
