/*
  sm_Callable.c
  map tools
  finucane@myri.com (David Finucane)
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#include "insist.h"
#include "mt_Component.h"
#include "sm_Callable.h"
#include "sm_EventList.h"

sm_Callable::sm_Callable()
{
  cHead = 0;
  numEvents = 0;
}

int sm_Callable::check()
{
  int c=0;

  sm_Event *e;
  sm_Event *last;

  e = cHead;
  last = 0;

  while(e)
  {
    c++;

    insistf (e->cPrev == last);

    last = e;
    e = e->cNext;
  }

  insistf (c == numEvents);

  return 1;
  exception: return 0;
}

void sm_Callable::addEvent(sm_EventList *list, sm_Time delta, int type, long data)
{
  sm_Time now;
  sm_Event *e;

  insistf(list);
  insistx (check());

  now = list->getCurrentTime();
  e = new sm_Event(type, now+delta, this, data);
  insistf(e);

  if (!cHead)
  {
    cHead = e;
    e->cNext = 0;
    e->cPrev = 0;
  }
  else
  {
    e->cNext = cHead;
    cHead->cPrev = e;
    e->cPrev = 0;
    cHead = e;
  }
  list->addEvent(e);

  numEvents++;
  insistx (check());

  exception: return;
}

void sm_Callable::extractEvent(sm_EventList *list, sm_Event *e)
{
  insistf(e);
  insistf(list);

  insistx (check());

  if (!e->cPrev)
    cHead = e->cNext;
  else
    e->cPrev->cNext = e->cNext;

  if (e->cNext)
    e->cNext->cPrev = e->cPrev;
  
  e->cNext = e->cPrev = 0;

  list->extractEvent(e);

  numEvents--;
  insistx (check());

  exception: return;
}

void sm_Callable::removeAllEvents(sm_EventList *list)
{
  sm_Event *e;
  sm_Event *eNext;

  insistf(list);

  e = cHead;
  while(e)
  {
    eNext = e->cNext;
    this->extractEvent(list,e);
    delete e;
    e = eNext;
  }

  exception: return;
}

void sm_Callable::removeEventsOfType(sm_EventList *list, int type)
{
  sm_Event *e;
  sm_Event *eNext;

  insistf(list);

  e = cHead;
  while(e)
  {
    eNext = e->cNext;
    if (e->type == type)
    {
      this->extractEvent(list,e);
      delete e;
    }
    e = eNext;
  }

  exception: return;
}


int sm_Callable::hasEvent (sm_EventList*list, int type)
{
  insistf (this);
  insistf (list);

  for (sm_Event*e = cHead; e; e = e->cNext)
    if (e->type == type || type == sm_EventList::ANY)
      return 1;
  exception: return 0;
}

