#ifndef mt_Tokenizer_h
#define mt_Tokenizer_h

#include <stdio.h>

#include "mt_Component.h"
#include "mt_LineReader.h"

class mt_Token : public mt_Component
{
  private:
  char*buffer;
  char*stream;
  char*token;
  const char*whitespace;
  int quoted;
  int lines;
  
  public:
  mt_Token (char*stream, const char*whitespace);
  char*getNext();
  char*getWord();
  int getInteger();
  int isInteger ();
  int isWord ();
  int getLineNumber ();
};

class mt_Tokenizer : public mt_Component
{
  private:
  enum
  {
    FORMAT_LEN = 20
  };
  
  mt_LineReader*reader;
  mt_Token*tokens;
  char whitespace [FORMAT_LEN];

  public:
  mt_Tokenizer (FILE*fp, const char*whitespace, int maxLine, const char*commentChars);
  mt_Tokenizer (char*filename, const char*whitespace, int maxLine, const char*commentChars);
  mt_Tokenizer (char*s, const char*whitespace);
  ~mt_Tokenizer ();
  char*getNext ();
  int isWord ();
  int getLineNumber ();
  int isInteger ();
  int getInteger ();
  char*getWord ();
  int equals (const char*s);
};

#endif /*mt_Tokenizer_h*/
