/*
  mt_Switch.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include "insist.h"
#include "mt_Switch.h"


int mt_Switch::getNodeType ()
{
  return mt_Node::SWITCH;
}

int mt_Switch::getMaxNodes ()
{
  return NUM_PORTS;
}

mt_Switch::mt_Switch (char*name, char*type) : mt_Node (name, type)
{
  for (int i = 0; i < NUM_PORTS; i++)
  {
    nodes [i] = 0;
    opposites [i] = -1;
  }
}

void mt_Switch::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = n;
  opposites [p] = o;
  
  exception: return;
}

void mt_Switch::disconnect (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = 0;
  opposites [p] = -1;
  
  exception: return;
}

mt_Node*mt_Switch::getNode (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return nodes [p];
  exception: return 0;
}


int mt_Switch::getOpposite (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return opposites [p];
  exception: return -1;
}
