/*
  mt_StringReader.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "insist.h"

#include "mt_StringReader.h"

mt_StringReader::mt_StringReader (char*s)
{
  insist (this);
  this->s = 0;
  line = 0;

  if (s)
  {
    this->s = new char [strlen (s) + 1];
    insistp (this->s, ("mt_StringReader::mt_StringReader: new failed"));
    strcpy (this->s, s);
  }
  exception: return;
}


mt_StringReader::~mt_StringReader ()
{
  if (s) delete [] s;
  s = 0;
}
  

char*mt_StringReader::readLine ()
{
  insist (this);
  if (!s) return 0;
    
  char*t;
  t = strtok (line ? 0 : s, "\n");
  if (t) line++;
  return t;
  exception: return 0;
}

int mt_StringReader::getLineNumber ()
{
  insist (this);
  return line;
  exception: return 0;
}

