/*
  mt_Responder.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Responder_h
#define mt_Responder_h

#include "mt_Mapper.h"

class mt_Responder : public mt_Job
{
  private:
  mt_Address address;
  mt_Address mapperAddress;
  int mapVersion;
  int gmId;
  int hostType;
  char hostname [mt_Network::HOSTNAME_LENGTH + 1];
  
  int scouts;
  int configures;
  
  void handleScout (mt_ScoutMessage*m, int length);
  void handleConfigure (mt_ConfigureMessage*m, int length);
  void handleOldConfigure (mt_OldConfigureMessage*m, int length);
  void printOldConfigureMessage (mt_OldConfigureMessage*m);
  int checkConfigure (mt_ConfigureMessage*m, int length);

  public:
  mt_Responder (mt_Node*node, mt_Network*network);
  virtual ~mt_Responder ();

  virtual void dump (FILE*fp);
  virtual int start ();
  virtual int willWait ();
  virtual void receive (int event, char*p, int length);
};


#endif /*mt_Responder_h*/
