/*
  mt_Respondern.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <string.h>

#include "insist.h"
#include "mt_htonl.h"
#include "mt_Responder.h"
#include "sm_Host.h"

mt_Responder::mt_Responder (mt_Node*node, mt_Network*network) : mt_Job (node, network), mapperAddress ()
{
  insist (node && network);
  insist (mapperAddress.isZero ());
  
  mapVersion = 0;
  gmId = node->getGmId ();
  hostType = 0;
  scouts = 0;
  configures = 0;
  
  exception: return;
}

mt_Responder::~mt_Responder ()
{
}

void mt_Responder::dump (FILE*fp)
{
  insist (this);
  insist (fp);
  exception: return;
}

int mt_Responder::start ()
{
  insist (this);
  int r;
  r = getNetwork ()->open (this, &address, hostname, &hostType, 0);
  insist (r);
  
  if (getNode ()->getAddress ()->isZero ())
    getNode ()->setAddress (&address);
  return 1;
  
  exception: return 0;
}
int mt_Responder::willWait ()
{
  insist (this);
  exception : return 0;
}

void mt_Responder::handleScout (mt_ScoutMessage*m, int length)
{
  insist (this);
  insist (m && length >= (int) sizeof (mt_ScoutMessage) - mt_Route::MAX_ROUTE);

  {
    m->swap ();
    insist (m->routeLength <= mt_Route::MAX_ROUTE);
    
    switch (m->command)
    {
      case mt_ScoutMessage::RESET:
	gmId = 0;
	mapVersion = 0;
	//printFormat ("%s got a reset", hostname);
	break;
      default:
	break;
    }
    
    mt_ReplyMessage r (m->port, m->phase, &address, &mapperAddress, gmId, 1, mapVersion, hostname, 0, 
		       hostType, getNode()->getReplyOption ());
    
    char*source = m->routeLength <= mt_Message::OLD_ROUTE_LENGTH ? m->route : m->extendedRoute;

    mt_Route::logical (source, source, m->routeLength);
    mt_Route route (source, m->routeLength);

    r.swap ();
    getNetwork ()->send (this, &route, (char*) &r, sizeof (r));
  }
  
  scouts++;
  exception: return;
}


void mt_Responder::printOldConfigureMessage (mt_OldConfigureMessage*m)
{
  char buffer [40];

  mt_Route::logical (m->route, m->route, m->routeLength);
  mt_Route r (m->route, m->routeLength);
  
  printFormat ("serial:%d", m->serial);
  printFormat ("route %s", r.toString (buffer));
  printFormat ("gmId:%d", m->gmId);
  printFormat ("mapVersion:%d", m->mapVersion);
  printFormat ("numItems:%d", m->numItems);
  
  for (int i = 0; i < m->numItems; i++)
  {
    printFormat ("address %d", m->items[i].address [0]);
    printFormat ("gmId %d", m->items[i].gmId);
    printFormat ("hostType %d", m->items[i].hostType);
    mt_Route::logical (m->items[i].route, m->items[i].route, m->items[i].routeLength);
    mt_Route r (m->items[i].route, m->items[i].routeLength);
    printFormat ("route %s", r.toString (buffer));   
    printFormat ("hostname %s\n", m->items[i].hostname);
  }
}


int mt_Responder::checkConfigure (mt_ConfigureMessage*m, int length)
{
  mt_Node*h,*n;
  mt_Graph*g;
  mt_Address a;
  char*p;
  int in;
  mt_Route route;
  
  insist (this);
  insist (m && length > (int) sizeof (mt_Message));
  
  h = getNode ();
  g = getNetwork ()->getGraph ();
  insist (h && g);

  p = m->getRoute (m->byteStream, &route);
  a.fromBytes (m->mapperAddress);
  
  if (!h->follow (&route, &n, &in) || !n || (a.compare (n->getAddress ())))
    return 0;
  
  if (m->numItems < 0 || m->numBytes < 0 || m->numBytes > length)
    return 0;

  for (int i = 0; i < m->numItems; i++)
  {
    mt_Node*o;
    char hostname [mt_Network::HOSTNAME_LENGTH];
    int gmId, hostType, control, numRoutes;
    
    if (!(p = m->getHost (p, &a, &gmId, &hostType, hostname, &control, &numRoutes)))
      return 0;
    
    if (!(o = g->getHost (&a)))
      return 0;

    if (numRoutes <= 0)
      return 0;
    
    for (int j = 0; j < numRoutes; j++)
    {
      if (!(p = m->getRoute (p, &route)))
	return 0;

      if (!h->follow (&route, &n, &in) || n != o)
	return 0;
    }
  }
  return 1;
  exception: return 0;
}

void mt_Responder::handleConfigure (mt_ConfigureMessage*m, int length)
{
  insist (this);
  insist (m && length);
  
  {
    m->swap ();
    mt_Route route;

    insist (checkConfigure (m, length));
    
    gmId = m->gmId;
    mapVersion = m->mapVersion;
    mapperAddress.fromBytes (m->mapperAddress);
    m->getRoute (m->byteStream, &route);
    
    mt_ConfigureReplyMessage r (m->port, m->hostSection, m->phase, &address);
    r.swap ();
    
    getNetwork ()->send (this, &route, (char*) &r, sizeof (r));
  }
  configures++;
  exception: return;
}



void mt_Responder::handleOldConfigure (mt_OldConfigureMessage*m, int length)
{
  insist (this);
  insist (m && length);
  
  {
    m->fromNetwork ();

    //printOldConfigureMessage (m);
    
    gmId = m->gmId;
    mapVersion = m->mapVersion;
    mapperAddress.fromBytes (m->mapperAddress);
    
    mt_ReplyMessage r (m->port, m->phase, &address, &mapperAddress, gmId, 1, mapVersion, hostname, 0, hostType, 0);
    mt_Route::logical (m->route, m->route, m->routeLength);
    mt_Route route (m->route, m->routeLength);

    r.swap ();
    
    getNetwork ()->send (this, &route, (char*) &r, sizeof (r));
  }
  configures++;
  exception: return;
}

void mt_Responder::receive (int event, char*p, int length)
{
  insist (this);

  switch (event)
  {
    case mt_Network::RECEIVE:
    {
      insist (p && length);
      insist ((unsigned) length >= sizeof (mt_Message));
      
      mt_Message*m;
      m = (mt_Message*) p;
      
      int mtype = mt_htons (m->type);
      int stype = mt_htons (m->subtype);

      insist (mtype == mt_Message::GM_TYPE);
      if (stype == mt_Message::SCOUT)
	handleScout ((mt_ScoutMessage*) m, length);
      else if (stype == mt_Message::OLD_CONFIGURE)
	handleOldConfigure ((mt_OldConfigureMessage*) m, length);
      else if (stype == mt_Message::CONFIGURE)
	handleConfigure ((mt_ConfigureMessage*) m, length);
      /* else
	insist (0); */
      break;
    }
    case mt_Network::SEND_DONE:
    case mt_Network::TIMEOUT:
    default:;
  }
  exception: return;
}
