/*
  mt_Queue.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Queue_h
#define mt_Queue_h

#include "mt_Component.h"
#include "mt_Queueable.h"

class mt_Queue : public mt_Component
{
  private:
  mt_Queueable*head;
  mt_Queueable*tail;
  int numItems;
  int maxItems;
  
  public:
  mt_Queue ();
  mt_Queue (int maxItems);
  int getNumItems ();
  void empty ();
  int isFull ();
  int isEmpty ();
  int put (mt_Queueable*n);
  mt_Queueable*get ();
  mt_Queueable*peek ();
  int isQueued (mt_Queueable*n);
  int remove (mt_Queueable*n);
  int check ();
};

#endif /*mt_Queue_h*/
