/*
  mt_Node.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Node_h
#define mt_Node_h

#include "mt_Queueable.h"
#include "mt_Route.h"
#include "mt_Address.h"
#if GM_OS_VXWORKS
#include "vxWorks.h"
#endif /*GM_OS_VXWORKS */
#include <stdarg.h>

class mt_Node;
class mt_Follower;

class mt_Node : public mt_Component, public mt_Queueable
{  
  public:
  enum
  {
    NAME_LENGTH = 128
  };
  enum
  {
    _NONE = 0,
    UP = 1,
    DOWN = 2
  };
  enum
  {
    NODE = 0,
    HOST, /*this had better be 1*/
    SWITCH,
    CLOUD,
    NUM_TYPES, /*add new types above this line*/
    NO_TYPE
  };
  
  int number;
  int height;
  int in;

  private:
  int mark;
  int mapVersion;
  int nodeIndex;
  int typeIndex;
  mt_Node*clonePointer;
  mt_Node*match;
  char name [NAME_LENGTH + 1];
  int routeIndex;
  mt_Route route;
  int meshX;
  int meshY;
  int meshZ;
  int lastHost;
  int replyType;
  
  protected:
  char type [NAME_LENGTH + 1];

  public:
  int follow (mt_Route*r, mt_Node**n, int*in, mt_Follower*follower = 0);
  mt_Node (const char*name, const char*type);
  mt_Node ();
  void setName (char*name);
  char*getName ();
  char*getType ();
  void startClone (mt_Node*n);
  void finishClone ();
  mt_Node*getNode (mt_Route*route);
  void setIn (int p);
  int getIn ();
  int getIn (mt_Route*route);
  void setMark (const int mark);
  int isMarked ();
  int getMark ();
  void setTypeIndex (int typeIndex);
  void setNodeIndex (int nodeIndex);
  int getTypeIndex ();
  int getNodeIndex ();
  virtual int getReplyOption ();

  mt_Node*getMatch ();
  void setMatch (mt_Node*m);
  
  void setRouteIndex (int p);
  int getRouteIndex ();
  int getNumNodes ();
  int getNumPorts (mt_Node*n);
  int getNumHosts ();
  int getMapVersion ();
  void setMapVersion (int mapVersion);
  mt_Node*getHost (mt_Address*address);
  mt_Node*getAnyHost ();
  int getPort (mt_Node*node, int k = -1);
  int getMeshX ();
  int getMeshY ();
  int getMeshZ ();
  int getDistance (mt_Node*n);
  mt_Node*absoluteToRelative (int numHops, char*hops);
  mt_Node*relativeToAbsolute (int numHops, char*hops);
  int isHost ();
  int isSwitch ();
  int isCloud ();
  int setHeight (int height);
  int getHeight ();
  
  virtual ~mt_Node ();
  virtual int getMaxStringLength ();
  virtual char*toString (char*s);
  virtual int setOption (char*option, char*value);
  virtual mt_Address*getAddress ();
  virtual void setAddress (mt_Address*address);
  virtual int getHostType ();
  virtual void setHostType (int hostType);
  virtual void setGmId (int gmId);
  virtual int getGmId ();
  virtual mt_Route*getRoute (int n);
  virtual void setRoute (int n, const mt_Route&r);
  virtual int getId ();
  virtual int getControl ();
  virtual int setControl (int control);
  virtual void setMissing (int missing);
  virtual int getMissing ();
  
  virtual int getNodeType () = 0;
  virtual int getMaxNodes () = 0;
  virtual void connect (int p, int o, mt_Node*n) = 0; /*only one-way*/
  virtual void connectMissingHost (int p, mt_Node*h); /*both ways*/
  virtual void disconnect (int p) = 0;
  virtual mt_Node*getNode (int p) = 0;
  virtual int getOpposite (int p) = 0;
};

#endif /*mt_Node_h*/

