/*
  mt_NetworkQueue.c
  map tools
  finucane@myri.com
*/

#include "insist.h"
#include "mt_NetworkQueue.h"

mt_NetworkQueue::mt_NetworkQueue (int size)
{
  this->size = size;
  
  items = new Item [size];
  insistp (items, ("mt_NetworkQueue::mt_NetworkQueue: alloc failed"));
	   
  empty ();
  exception: return;
}

void mt_NetworkQueue::empty ()
{
  head = tail = 0;  
}
  
mt_NetworkQueue::~mt_NetworkQueue ()
{
  if (items) delete items;
}

int mt_NetworkQueue::isFull ()
{
  return (tail + 1 == head) || (tail == size - 1 && head == 0);
}

int mt_NetworkQueue::isEmpty ()
{
  return tail == head;
}

int mt_NetworkQueue::put (void *p)
{
  return put (p, 1, 0);
}
void*mt_NetworkQueue::get ()
{
  void*p = 0;
  int length;
  get (&p, &length);
  return p;
}

int mt_NetworkQueue::put (void *p, int length, int routeLength, int context)
{
  insist (p);
  insist (length > 0);

  if (isFull ())
    return 0;
    
  items[tail].pointer = p;
  items[tail].length = length;
  items[tail].routeLength = routeLength;
  items[tail].context = context;

  if (++tail == size)
    tail = 0;
  return 1;
  exception: return 0;
}

int mt_NetworkQueue::get (void **p, int*routeLength, int *context)
{
  insist (p);

  if (isEmpty ())
    return 0;
  int h;
  h = head;
  if (++head == size)
    head = 0;

  *p = items[h].pointer;
  if (context)
    *context = items[h].context;
  if (routeLength)
    *routeLength = items[h].routeLength;

  insist (items[h].length >= 0);
  return items[h].length;
  exception: return 0;
}
