/*
  mt_Message.h
  map tools
  finucane@myri.com
*/

#ifndef mt_Message_h
#define mt_Message_h

#include "mt_Address.h"
#include "mt_Route.h"
#include "mt_Network.h"
#include "mt_htonl.h"

typedef char mtu8;
typedef short mtu16;
typedef int mtu32;

class mt_Message
{
  public:
  mtu16 type;
  mtu16 subtype; 
  mtu32 port;
  mtu32 phase;
 
  enum
  {
    OLD_HOSTNAME_LENGTH = 32,
    HOSTNAME_LENGTH = 128,
    OLD_ROUTE_LENGTH = 32,
    GM_TYPE = 0xf,
    MAX_CONFIGURE_ROUTES = 48,
    MAX_CLOUD_HOSTS = 16 //175
  };
  
  enum replyOptions
  {
    NO_OPTION = 0,
    CLOUD_OPTION = 1,
    PACKED_ROUTES_OPTION = 2,
    LONG_HOSTNAME_OPTION = 4
  };
  
  enum subtypes
  {
    SCOUT = 0,
    OLD_CONFIGURE = 1,
    REPLY = 2,
    PROBE = 3,
    VERIFY = 4,
    COMPARE = 5,
    ID_PROBE = 6,
    CLOUD_QUERY = 7,
    CLOUD_QUERY_REPLY = 8,
    CONFIGURE = 9,
    CONFIGURE_REPLY = 10,
    NUM_TYPES
  };
  static const char*names [NUM_TYPES];
  
  mt_Message (int subtype, int port, int phase);
  mt_Message ();
  void swap ();
  void dump (int length);
};

class mt_ScoutMessage : public mt_Message
{
  public:

  enum
  {
    _NONE = 0,
    RESET = 1
  };

  mtu32 routeLength;
  mtu8 route [OLD_ROUTE_LENGTH];
  mtu8 address [mt_Address::NUM_BYTES];
  mtu16 command;
  mtu32 level;
  mtu8 extendedRoute [mt_Route::MAX_ROUTE]; //to be truncated

  mt_ScoutMessage (int port, int phase, mt_Route*route, mt_Address*address, int level, int command=_NONE);
  void swap ();
  void physical ();
  int getSize ();
  void*operator new (size_t size, int routeLength);
  void operator delete (void*p);
};

class mt_ProbeMessage : public mt_Message
{
  public:

  mt_ProbeMessage (int port, int phase);
};


class mt_CompareMessage : public mt_Message
{
  public:

  mt_CompareMessage (int port, int phase, int index);
  int getIndex ();
  int getPort ();
};

class mt_IdProbeMessage : public mt_Message
{
  public:
  mtu32 id;
  mtu16 inPort;
  mtu16 numPorts;
  
  mt_IdProbeMessage (int port, int phase);
  void swap ();
};


class mt_ReplyMessage : public mt_Message
{
  public:
  mtu8 address [mt_Address::NUM_BYTES];
  mtu8 mapperAddress [mt_Address::NUM_BYTES];
  mtu16 gmId;
  mtu8 mapperRunning;
  mtu8 pad;
  mtu32 mapVersion;

  private:
  mtu8 oldHostname [OLD_HOSTNAME_LENGTH];

  public:
  mtu32 level;
  mtu16 hostType;
  mtu16 option; //may be truncated after this field

  private:
  mtu8 hostname [HOSTNAME_LENGTH];
  
  public:
  mt_ReplyMessage (int port, int phase, mt_Address*address, mt_Address*mapperAddress,
		   short gmId,  int mapperRunning, int mapVersion, char*hostname, int level, short hostType,
		   short option);
  void swap ();
  char*getHostname ();
};

class mt_CloudHost
{
  public:
  mtu8 address [mt_Address::NUM_BYTES];
  mtu16 control;
};

class mt_CloudReplyMessage : public mt_ReplyMessage
{
  public:
  mtu32 numHosts;
  mt_CloudHost hosts [mt_Message::MAX_CLOUD_HOSTS];

  mt_CloudReplyMessage (int port, int phase, mt_Address*address, mt_Address*mapperAddress,
			short gmId,  int mapVersion, char*hostname, int level, short hostType, 
			int numHosts);

  void swap ();
};


class mt_CloudQueryMessage : public mt_Message
{
  public:
  mtu32 routeLength;
  mtu32 first;
  mtu32 numHosts;
  mtu8 route [mt_Route::MAX_ROUTE]; /*to be truncated*/

  mt_CloudQueryMessage (int port, int phase, mt_Route*route, int first, int numHosts);
  mt_CloudQueryMessage ();
  void swap ();
  int getSize ();
};

class mt_CloudQueryReplyMessage : public mt_Message
{
  public:
  mtu8 address [mt_Address::NUM_BYTES];
  mtu16 pad;
  mtu32 first;
  mtu32 numHosts;
  mt_CloudHost hosts [mt_Message::MAX_CLOUD_HOSTS];

  mt_CloudQueryReplyMessage (int port, int phase, mt_Address*address, int first, int numHosts);

  void swap ();
};

class mt_VerifyMessage : public mt_Message
{
  public:

  mt_VerifyMessage (int phase);
};

class mt_OldConfigureMessage : public mt_Message
{
  public:
  class Item
  {
    public:
    mtu8 address [mt_Address::NUM_BYTES];
    mtu16 gmId;
    mtu16 hostType;
    mtu16 routeLength;
    mtu8 route [OLD_ROUTE_LENGTH];
    mtu8 hostname [OLD_HOSTNAME_LENGTH];
    mtu16 control;
    mtu16 _pad;
  };
  mtu32 serial;
  mtu32 routeLength;
  mtu8 route [OLD_ROUTE_LENGTH];
  mtu8 address[mt_Address::NUM_BYTES];
  mtu8 mapperAddress[mt_Address::NUM_BYTES];
  mtu16 gmId;
  mtu16 numHosts;
  mtu32 mapVersion;
  mtu32 numItems;
  Item items [1];

  void*operator new (size_t size, int maxItems);
  void operator delete (void*p);
  mt_OldConfigureMessage ();
  void setPhase (int phase);
  void setGmId (int gmId);
  void setNumHosts (int numHosts);
  void setAddress (mt_Address*address);
  void setMapperAddress (mt_Address*mapperAddress);
  void setRoute (mt_Route*route);
  void setPart (int part);
  void setMapVersion (int mapVersion);
  void setNumItems (int numItems);
  void setSerial (int serial);
  int sizeOf (int numItems);
  void set (int item, mt_Address*address, int gmId, int hostType,
	    mt_Route*route, char*hostname);
  void fromNetwork ();
};


class mt_ConfigureMessage : public mt_Message
{
  public:

  enum
  {
    BASE_SIZE = 10 * sizeof (mtu32),
    SIZE_PER_HOST = 5 * sizeof (mtu32),
    SIZE_PER_ROUTE = sizeof (mtu8),
    MAX_BYTE_STREAM = mt_Network::MTU - sizeof (mt_Message) - BASE_SIZE
  };
  mtu32 hostSection;
  mtu8 address[mt_Address::NUM_BYTES];
  mtu8 mapperAddress[mt_Address::NUM_BYTES];
  mtu16 gmId;
  mtu16 numHosts;
  mtu32 mapVersion;
  mtu32 numItems;
  
  mtu32 numBytes;
  char byteStream [MAX_BYTE_STREAM];

  /*
    byteStream:

    mtu8 return-route-length
    mtu8 return-route[]

    mtu8 address [6]
    mtu16 gm-id
    mtu16 host-type
    mtu16 control
    mtu8 hostname-length
    mtu8 hostname []
    mtu8 num-routes
    mtu8 route-length
    mtu8 route []

    mtu8 address [6]
    mtu16 gm-id
    mtu16 host-type
    mtu16 control
    mtu8 hostname-length
    mtu8 hostname []
    mtu8 num-routes
    mtu8 route-length
    mtu8 route []

      ...
  */
  mt_ConfigureMessage ();
  void swap ();
  int setHeader (int phase, int host, int hostSection, mt_Address*address, mt_Address*mapperAddress,
		 int gmId, int numHosts, int mapVersion, int numItems, mt_Route*route);
  char*getHost (char*p, mt_Address*address, int*gmId, int*hostType, char*hostname, int*control, int*numRoutes);
  char*getRoute (char*p, mt_Route*r);
  int append (mt_Address*address, int gmId, int hostType, int control, char*hostname, int numRoutes);
  int append (mt_Route*r);
  int append (char*p, int var, int size);
  int getSize ();
  char*read16 (char*p, int*var);
  char*read32 (char*p, int*v);
};

class mt_ConfigureReplyMessage : public mt_Message
{
  public:
  mtu8 address [mt_Address::NUM_BYTES];
  mtu16 pad;
  mtu32 hostSection;
  
  mt_ConfigureReplyMessage (int host, int hostSection, int phase, mt_Address*address);
  void swap ();
};


#endif /*mt_Message_h*/
