/*
  mt_MapperOptions.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Options_h
#define mt_Options_h

#include "mt_Args.h"
#include "mt_File.h"
#include "mt_Node.h"
#include "mt_Switch.h"

class mt_MapperOptions : public mt_Component
{
  private:
  int badScoutPhases;
  int badProbePhases;
  int minScoutTime;
  int maxScoutTime;
  int minProbeTime;
  int maxProbeTime;
  
  public:
  enum
  {
    MAX_TRIES = 100,
    MAX_UNIT = 32,
    MAX_MICROSECONDS = 1000 * 1000,
    MAX_MILLISECONDS = 1000 * 60 * 30
  };
  
  char mapperName [mt_Node::NAME_LENGTH + 1];
  char mapFile [mt_File::FILENAME_LENGTH + 1];
  char hostFile [mt_File::FILENAME_LENGTH + 1];
  char countersFile [mt_File::FILENAME_LENGTH + 1];
  char routesFile [mt_File::FILENAME_LENGTH + 1];
  int configureOnce;
  int mapOnce;
  int neverConfigure;
  int neverEnd;
  int expectedNodes;
  int expectedHosts;
  int maxConfigureRoutes;
  int maxConfigureByteStream;
  int scoutTries;
  int probeTries;
  int configureTries;
  int timeoutIncrease;
  int timeoutDecrease;
  int scoutMicroseconds;
  int probeMicroseconds;
  int configureMicroseconds;
  int verifyProbeTries;
  int verifyScoutTries;
  int verifyProbeMicroseconds;
  int verifyScoutMicroseconds;
  int rememberNodes;
  int soreLoser;
  int makeHosts;
  int measureLatency;
  int measureConfigureLatency;
  int findLoops;
  int unit;
  int level;
  int verify;
  int verifyHosts;
  int compareSwitches;
  int sendManyAtOnce;
  int sendManyConfigures;
  int sendManyCompares;
  int passiveMilliseconds;
  int activeMilliseconds;
  int verbose;
  int veryVerbose;
  int justSetHostname;
  int neverConfigureOthers;
  int neverSetHostname;
  int maxDepth;
  int probeSwitches;
  int interleaveConfigures;
  int resendConfiguresInOrder;
  char bootHost [mt_Node::NAME_LENGTH + 1];
  int fishGuts;
  int numChangedMaps;
  int numUnchangedMaps;
  int thrash;
  int uniqueHostFile;
  int shortHostnames;
  int addMissingHosts;
  int configureMissingHosts;
  int testDeadlock;
  int warnings;
  int numReceiveBuffers;
  int growConfigureTimeouts;
  int clearRoutes;
  int maxTimeout;
  int fillGmIdGaps;
  int configureOnlyWhenThereAreUnconfiguredHosts;
  mt_MapperOptions ();
  void usage ();
  int parseArgs (mt_Args*args);
  int handleBadPhase (int messageType);
  int decreaseTimeouts ();
  int increaseTimeouts (int type);
  int setTimeouts (int scout, int probe, int configure);
};

#define HOST_FILE_FORMAT "%s.hosts"

#endif /*mt_MapperOptions_h*/
