/*
  mt_Job.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef mt_Job_h
#define mt_Job_h

#include <stdio.h>

#include "mt_Component.h"
#include "mt_Node.h"

class mt_Network;

class mt_Job : public mt_Component
{
  private:
  int opened;
  mt_Node*node;
  mt_Network*network;
  
  public:
  mt_Job (mt_Node*node, mt_Network*network);
  virtual ~mt_Job ();
  mt_Node*getNode ();
  mt_Network*getNetwork ();
  int getOpened ();
  void setOpened (int opened);

  virtual void dump (FILE*fp) = 0;
  virtual int willWait () = 0;
  virtual int start () = 0;
  virtual void receive (int event, char*p, int length) = 0;
};

#endif /*mt_Job_h*/
