/*
  mt_HostTable.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_HostTable_h
#define mt_HostTable_h

#include <stdio.h>

#include "mt_Component.h"
#include "mt_Address.h"
#include "mt_Graph.h"

class mt_HostTable : public mt_Component
{
  public:
  enum
  {
    HOSTNAME_LENGTH = 128
  };
  
  class Item
  {
    public:
    mt_Address address;
    int gmId;
    int state;
    int hostType;
    int option;
    char hostname [HOSTNAME_LENGTH + 1];
    int toString (char*s);
  };
  private:
  Item dummy;
  Item*items;
  int numItems;
  int maxItems;
  int sortType;
  int maxGmId;
  Item*lastItem;
  void grow (); 
  Item*find (mt_Address*address);
  Item*find (char*hostname);
  Item*slowFind (mt_Address*address);
  Item*slowFind (char*hostname);
  int getNextGap (int*position, int*length, int*offset);

  
  mt_Address*getAddress (int gmId);
  void sortByAddress();
  void sortByGmId();
  void sortByName ();
  
  public:
  enum states
  {
    FIRST_SEEN = 1,
    NOT_CONFIGURED,
    CONFIGURED,
    INCONSISTENT
  };
  enum sorts
  {
    UNSORTED = 0,
    BY_ADDRESS = 1,
    BY_ID = 2,
    BY_NAME = 3
  };
  
  mt_HostTable (); 
  ~mt_HostTable ();
  void initialize ();
  mt_HostTable (char*filename);
  int add (int gmId, int hostType, mt_Address*address, char*name); 
  int replace (int gmId,  mt_Address*address);
  int add (int gmId, int hostType, mt_Address*address);
  int add (mt_Address*address, int hostType); 
  int getGmId (mt_Address*address); 
  int getNumItems();
  int getState (mt_Address*address);
  void setState (mt_Address*address, int state);
  int getHostType (mt_Address*address);
  void setHostname (mt_Address*address, char*s);
  char*getHostname (mt_Address*address);
  int toFile (FILE*fp);
  int resolve (int gmId, int hostType, mt_Address*address);
  int assignGmIds (mt_Graph*graph);
  int assignGmIdsByFillingInGaps (mt_Graph*graph);
  int assignAddresses (mt_Graph*graph);
  int setStates (int state);
  int getOption (mt_Address*address);
  void setOption (mt_Address*address, int option);
  
  int check ();
};

#endif /*mt_HostTable_h*/
