/*
  mt_Graph.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Graph_h
#define mt_Graph_h

#include "mt_NodeFactory.h"
#include "mt_Queue.h"

typedef int (*mt_GraphRemoveLinksFunction) (mt_Node*n1, mt_Node*n2, int p);

class mt_Graph : public mt_Component, public mt_NodeFactory
{
  private:
  mt_Queue queue;
  volatile int numNodes [mt_Node::NUM_TYPES];
  int maxNodes [mt_Node::NUM_TYPES];
  mt_Node**nodes [mt_Node::NUM_TYPES];
  int maxStringLengths [mt_Node::NUM_TYPES];
  mt_Node*root;
  
  mt_Node*getNode (int type, int x, int y, int z);
  
  public:
  int getNumNodes (int type);
  mt_Node*getNode (int type, int index);
  
  mt_Graph ();
  int clone (mt_Graph*g);
  int stringEquals (mt_Graph*g);
  int equals (mt_Graph*g);
  int match (mt_Node*n1, mt_Node*n2);
  int matchKids (mt_Node*n1, mt_Node*n2);

  mt_Node*unequalMapVersions (mt_Graph*g);
  int renumber (int host);
  int renumber (int numRoots, char**roots);
  int renumber (int numRoots, mt_Node**roots);
  int autoNumber ();
  void clearNumbers ();
  void clearMarks ();
  int getMaxNodeStringLength ();
  int getMaxStringLength ();
  mt_Node*getNode (int n);
  mt_Node*getNode (char*name);
  int getHostIndex (char*name);
  mt_Node*getHost (int n);
  mt_Node*getHost (mt_Address*address);
  mt_Node*getNode (int type, mt_Address*address);
  mt_Node*getSwitch (int n);
  mt_Node*getSwitch (int x, int y, int z = 0);
  mt_Node*getNumberedSwitch (int n);
  mt_Node*getRoot ();
  void setRoot (mt_Node*n);
  mt_Node*getHost (int x, int y, int z = 0);
  
  int setSize (int type, int size);
  void add (mt_Node*n);
  void remove (mt_Node*n);
  int getNumNodes ();
  int getNumHosts ();
  int getNumSwitches ();
  int toString (char*s);
  int setRoutes (mt_Node*root);
  int removeMarked (int mark);
  int removeSteppenwoelfe ();
  int removeLinks (mt_GraphRemoveLinksFunction function);
  mt_Node*getGmId (int id);
  int getMaxMapVersion ();
  int fillLevels (mt_Node*node, mt_Node**nodes, mt_Node***levels, int*nodesPerLevel, int maxLevel);
  int computeRoutes (mt_Node*root);
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
  virtual void empty ();
  virtual ~mt_Graph ();
};

#endif /*mt_Graph_h*/
