/*
  mt_Gm.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef mt_Gm_h
#define mt_Gm_h

#include "mt_Network.h"
#include "mt_NetworkQueue.h"

class mt_Gm : public mt_Network
{
  private:
  mt_Job*job;
  mt_NetworkQueue smallSends;
  mt_NetworkQueue smallBuffers;
  mt_NetworkQueue bigSends;
  mt_NetworkQueue bigBuffers;
  int bigTokens;
  int smallTokens;
  char*bigStart;
  char*bigEnd;
  char*smallStart;
  char*smallEnd;
  int openCount;
  int numBadLengths;
  int numReceiveBuffers;
  int sentDoneLength;
  
  void reclaimSend (void*p);
  void flushSends ();
  int receivePacket (int isRaw, void*buffer, void*mp, int mlength, char**p, int*length);
  int receive (char**p, int*length);
  
  public:
  int alarmed;
  mt_Gm ();
  virtual ~mt_Gm ();

  virtual mt_Graph*getGraph ();
  virtual int getRoute (int from, int to, int index, mt_Route*route);
  virtual int getNumRoutes (int from, int to);

  virtual int parseArgs (mt_Args*args);
  virtual void usage ();
  virtual void dump ();
  virtual void run ();
  virtual int wait (char**p, int*length);
  virtual void freePacket (char*p);

  virtual int open (mt_Job*job, mt_Address*address, char*hostname, int*type, int unit, int numReceiveBuffers);
  virtual void close (mt_Job*job);
  virtual int send (mt_Job*job, mt_Route*route, char*p, int length);
  virtual int sendWithPadding (mt_Job*job, mt_Route*route, char*p, int length, int totalLength);
  virtual void setTimer (mt_Job*job, int microseconds);
  virtual void clearTimer (mt_Job*job);
  virtual void setRoute (mt_Job*job, int gmId, mt_Route*route);
  virtual void setAddress (mt_Job*job, int gmId, mt_Address*address);
  virtual void setHostname (mt_Job*job, int gmId, char*hostname);
  virtual void setGmId (mt_Job*job, int gmId);
  virtual int getGmId (mt_Job*job);
  virtual void setLevel (mt_Job*job, int level);
  virtual mt_Int64 getCurrentTime ();
  virtual void clearRoutes (mt_Job*job);
  virtual int getNumReceiveBuffers ();
  virtual int getReceiveMtu ();
  virtual int enableCrc ();
  virtual int disableCrc ();
  virtual int writeRegister (unsigned int offset, unsigned int value);
  virtual int getSentDoneLength ();
};

#endif /*mt_Gm_h*/
