/*
  mt_FileWriter.h
  map tools
  finucane@myri.com (David Finucane)
*/

#include <string.h>

#include "insist.h"
#include "mt_FileWriter.h"

void mt_FileWriter::setTemp (char*s, char*filename)
{
  insist (s);
  char*base;
  base = strrchr (filename,'/');
  if (!base)
    base = strrchr (filename, '\\');
  if (!base)
    base = filename - 1;
  base++;
  insist (base);
  strncpy (s, filename, base - filename);
  s += (base - filename);
  *s++='.';
  strcpy (s, base);
  exception: return;
}

mt_FileWriter::mt_FileWriter (char*filename)
{
  fp = 0;
  insist (filename && *filename);
  strncpy (file, filename, FILENAME_LENGTH);

#if defined (MT_ppc_vxWorks)
  strncpy (temp, filename, FILENAME_LENGTH);

  if (fp = fopen (temp, "r"))
  {
    fclose (fp);
    remove (temp);
  }
  fp = 0;
#else
  setTemp (temp, file);
#endif

  if (!(fp = fopen (temp, "w+")))
  {
    printFormat ("couldn't open temp file \"%s\"", temp);
    return;
  }
  exception: return;
}

mt_FileWriter::~mt_FileWriter ()
{
  if (fp)
  {
    fclose (fp);

    fp = 0;
#if !defined (MT_ppc_vxWorks)
    if (rename (temp, file))
    {
      remove (file);
      /*this could still fail too because NT is bad
	software. It happens too often to report.*/
      rename (temp, file);
    }
#endif
  }
}
