/*
  mt_FileReader.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "insist.h"

#include "mt_FileReader.h"

mt_FileReader::mt_FileReader (FILE*fp, int maxLine, const char*commentChars)
{
  insist (this);
  insist (commentChars);
  
  this->fp = this->myFp = 0;
  line = 0;
  insist (fp);
  this->fp = fp;
  this->maxLine = maxLine;
  lineNumber = 0;
  strncpy (this->commentChars, commentChars, MAX_COMMENT_CHARS);
  line = new char [maxLine + 1];
  insist (line);
    
  exception:return;
}
  
mt_FileReader::mt_FileReader (const char*filename, int maxLine, const char*commentChars)
{
  insist (this);
  insist (commentChars);

  line = 0;
  lineNumber = 0;
  myFp = fp = 0;
  insist (filename && maxLine > 0);
  this->maxLine = maxLine;
  strncpy (this->commentChars, commentChars, MAX_COMMENT_CHARS);

  myFp = fp = fopen (filename, "r");
  insistp (fp, ("mt_FileReader::mt_FileReader: couldn't open file \"%s\"", filename));
  
  line = new char [maxLine + 1];
  insist (line);

  exception:return;
}

char*mt_FileReader::readLine()
{
  insist (this);
  if (!fp) return 0;

  char*s;
  while ((s = fgets (line, maxLine, fp)))
  {
    lineNumber++;
    
    char*a = line;    
    while (*a && isspace (*a))
      a++;

    if (!*a || !strchr (commentChars, *a))
      break;
  }
  
  return s;
  exception: return 0;
}

mt_FileReader::~mt_FileReader ()
{
  if (line)
    delete [] line;
  if (myFp)
    fclose (myFp);
  line = 0;
  myFp = 0;
}
  
int mt_FileReader::getLineNumber ()
{
  insist (this);
  insist (lineNumber >= 0);
  return lineNumber;
  exception: return 0;
}
