/*
  mt_File.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef mt_File_h
#define mt_File_h

#include <stdio.h>

#include "mt_Component.h"

class mt_File : public mt_Component
{
  public:
  enum
  {
    _WRITE = 1,
    _READ = 2,
    FILENAME_LENGTH = 255,
    MAX_LINE = 2000
  };
  
  protected:
  FILE*fp;
  FILE*myFp;

  mt_File (const char*filename, int mode);
  mt_File (FILE*fp);
  virtual ~mt_File ();

  public:
  static void getFullPath (char*fullname, char*filename);
  static void replaceFilePart (char*fullname, char*filename);
  static char*combine (char*buffer, char*dir, char*filename);

};

#endif /*mt_File_h*/

