/*
  mt_File.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "insist.h"
#include "mt_File.h"

mt_File::mt_File (const char*filename, int mode)
{
  fp = myFp = 0;

  insist (filename);
  insist (mode == _WRITE || mode == _READ);

  fp = myFp = fopen (filename, mode == _WRITE ? "w" : "r");
  insistp (fp, ("mt_File::mt_File: couldn't open \"%s\".",
		filename));

  exception: return;  
}

void mt_File::replaceFilePart (char*fullname, char*filename)
{
  char*s;

  if (!fullname || !filename) return;
 
  
#if  defined (MT_intel_ms)
  s = strrchr (fullname, '\\');
#else
  s = strrchr (fullname, '/');
#endif
  
  if (!s) s = fullname -1;
  *(s + 1) = 0;
  strcat (fullname, filename);
}


void mt_File::getFullPath (char*fullname, char*filename)
{
  char file [FILENAME_LENGTH + 1];
  
  if (!fullname || !filename) return;
  

  strncpy (file, filename, FILENAME_LENGTH);
  
#if defined (MT_intel_ms)
  if (!strchr (filename, ':') && !strchr (filename, '\\'))
  {
    char base [FILENAME_LENGTH + 1];
    *base = 0;
    char*s;
    
    if ((s = getenv ("SYSTEMROOT")))
      sprintf (base, "%s\\GM",s);
    else sprintf (base, "c:");
    
    sprintf (fullname, "%s\\%s", base, file);
  }
#endif
}

char*mt_File::combine (char*buffer, char*dir, char*filename)
{

  insistf (buffer && dir && filename && *dir && *filename);
  
#if defined (MT_intel_ms)
  sprintf (buffer, "%s\\%s", dir, filename);
#else
  sprintf (buffer, "%s/%s", dir, filename);
#endif
  return buffer;
  exception: return 0;
}


mt_File::mt_File (FILE*fp)
{
  myFp = this->fp = 0;
  
  insist (fp);
  
  this->fp = fp;
  
  exception: return;
}

mt_File::~mt_File ()
{
  if (myFp) fclose (myFp);
}
