/*
  mt_Component.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Component_h
#define mt_Component_h

#if GM_OS_VXWORKS
#include "vxWorks.h"
#endif /*GM_OS_VXWORKS */
#include <stdarg.h>

typedef void (*mt_PrintLineFunction) (char*s);


#ifdef MT_intel_ms
typedef __int64 mt_Int64;
#else
typedef long long mt_Int64;
#endif

#ifdef MT_intel_ms
#if (_MSC_VER == 1100)
#define mt_fp(f)f
#elif (_MSC_VER >= 1200)
#define mt_fp(f)&f
#else
#error not compiling with VC5 or VC6
#endif
#else
#define mt_fp(f)&f
#endif

#define mt_abs(x)((x) >= 0 ? x : -(x))

class mt_Component
{
  private:
  enum
  {
    CREATED = 0x12345678
  };
  static int seed;
  int destroyed;
  int created;
  
  public:
  enum
  {
    MAX_PRINTLINE = 2000
  };
  
  mt_Component ();
  virtual ~mt_Component ();
  int validComponent () const;
  static void initialize (mt_PrintLineFunction function);
  static void srand (int seed = 0);
  static int rand (int afterMax);
  static void printFormat (const char*fmt, ...);
  static void printInsist (const char*fmt, ...);
};


#endif /*mt_Component_h*/


