/*
  mt_CloudResponder.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_CloudResponder_h
#define mt_CloudResponder_h

#include "mt_Mapper.h"

class mt_CloudResponder : public mt_Job
{
  private:
  mt_Address address;
  mt_Address mapperAddress;
  int mapVersion;
  int gmId;
  int hostType;
  char hostname [mt_Network::HOSTNAME_LENGTH + 1];
  
  int scouts;
  
  void handleScout (mt_ScoutMessage*m, int length);
  void handleCloudQuery (mt_CloudQueryMessage* m, int length);
  
  public:
  mt_CloudResponder (mt_Node*node, mt_Network*network);
  virtual ~mt_CloudResponder ();

  virtual void dump (FILE*fp);
  virtual int start ();
  virtual int willWait ();
  virtual void receive (int event, char*p, int length);
};


#endif /*mt_CloudResponder_h*/
