/*
  mt_CloudRespondern.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <string.h>

#include "insist.h"
#include "mt_htonl.h"
#include "mt_Cloud.h"
#include "mt_CloudResponder.h"

mt_CloudResponder::mt_CloudResponder (mt_Node*node, mt_Network*network) : mt_Job (node, network), mapperAddress ()
{
  insist (node && network);
  insist (mapperAddress.isZero ());
  insist (node->getNodeType () == mt_Node::CLOUD);
  
  mapVersion = 0;
  hostType = 0;
  
  exception: return;
}

mt_CloudResponder::~mt_CloudResponder ()
{
}

void mt_CloudResponder::dump (FILE*fp)
{
  insist (this);
  insist (fp);
  exception: return;
}

int mt_CloudResponder::start ()
{
  insist (this);
  int r;
  r = getNetwork ()->open (this, &address, hostname, &hostType, 0);
  insist (r);
  
  if (getNode ()->getAddress ()->isZero ())
    getNode ()->setAddress (&address);
  return 1;
  
  exception: return 0;
}
int mt_CloudResponder::willWait ()
{
  insist (this);
  exception : return 0;
}

void mt_CloudResponder::handleScout (mt_ScoutMessage*m, int length)
{
  insist (this);
  insist (m && length >= (int) sizeof (mt_ScoutMessage) - mt_Route::MAX_ROUTE);

  {
    m->swap ();
    insist (m->routeLength <= mt_Route::MAX_ROUTE);
    
    switch (m->command)
    {
      case mt_ScoutMessage::RESET:
	//printFormat ("%s got a reset", hostname);
	break;
      default:
	break;
    }

    mt_Node*cloudNode = getNode();
    int numHosts = cloudNode->getNumNodes () - 1;
    
    insist (numHosts >= 0);
    
    mt_CloudReplyMessage r (m->port, m->phase, &address, &mapperAddress, gmId, mapVersion, hostname, 0, hostType, numHosts);

    int toSend;
    toSend = numHosts < mt_Message::MAX_CLOUD_HOSTS ? numHosts : mt_Message::MAX_CLOUD_HOSTS;
    
    for (int i = 0; i < toSend; i++)
    {
      mt_Node*h = cloudNode->getNode (i  + 1);
      insist (h);

      h->getAddress ()->copyOut (r.hosts [i].address);
      r.hosts [i].control = 0;
    }
    
    char*source = m->routeLength <= mt_Message::OLD_ROUTE_LENGTH ? m->route : m->extendedRoute;
    mt_Route::logical (source, source, m->routeLength);
    mt_Route route (source, m->routeLength);

    r.swap ();
    getNetwork ()->send (this, &route, (char*) &r, sizeof (r));
  }
  
  exception: return;
}

void mt_CloudResponder::handleCloudQuery (mt_CloudQueryMessage* m, int length)
{
  insist (this);
  insist (m && length >= (int) sizeof (mt_Message));

  m->swap ();

  mt_Node*cloudNode;
  cloudNode = getNode ();

  
  int numHosts;
  numHosts = cloudNode->getNumNodes () - 1;
  
  insist (m->first >= 0 && m->first <= numHosts);
  insist (m->numHosts > 0 && m->numHosts <= mt_Message::MAX_CLOUD_HOSTS);
  insist (m->numHosts <= 1 +  numHosts - m->first);
 
  {
    mt_CloudQueryReplyMessage r (m->port, m->phase, &address, m->first, m->numHosts);
    
    for (int i = 0; i < m->numHosts; i++)
    {
      mt_Node*h = cloudNode->getNode (m->first + i  + 1);
      insist (h);
      
      h->getAddress ()->copyOut (r.hosts [i].address);
      r.hosts [i].control = 0;
    }
    
    mt_Route::logical (m->route, m->route, m->routeLength);
    mt_Route route (m->route, m->routeLength);
    
    r.swap ();
    getNetwork ()->send (this, &route, (char*) &r, sizeof (r));
  }
  
  exception:return;
}


void mt_CloudResponder::receive (int event, char*p, int length)
{
  insist (this);

  switch (event)
  {
    case mt_Network::RECEIVE:
    {
      insist (p && length);
      insist ((unsigned) length >= sizeof (mt_Message));
      
      mt_Message*m;
      m = (mt_Message*) p;

      int mtype = mt_htons (m->type);
      int stype = mt_htons (m->subtype);
      
      insist (mtype == mt_Message::GM_TYPE);
      if (stype == mt_Message::SCOUT)
	handleScout ((mt_ScoutMessage*) m, length);
      else if (stype == mt_Message::CLOUD_QUERY)
	handleCloudQuery ((mt_CloudQueryMessage*) m, length);
      /* else
	insist (0); */
      break;
    }
    case mt_Network::SEND_DONE:
    case mt_Network::TIMEOUT:
    default:;
  }
  exception: return;
}
