/*
  mt_Cloud.c
  map tools
  finucane@myri.com
*/

#include "stdlib.h"
#include "mt_Cloud.h"
#include "insist.h"

mt_Cloud::mt_Cloud (char*name, char*type) : mt_Node (name, type)
{
  nodes = 0;
  opposite = -1;
  
  insist (name && type && *name && *type);
  
  numNodes = atoi (type);
  insistp (numNodes > 0, ("mt_Cloud::mt_Cloud: %d is not a good cloud node count", type));
  
  nodes = new mt_Node* [numNodes];
  insistp (nodes, ("mt_Cloud::mt_Cloud: new () of %d node pointers failed", numNodes));
  
   for (int i = 0; i < numNodes; i++)
    nodes [i] = 0;
  
  exception: return;
}

mt_Cloud::~mt_Cloud ()
{
  if (nodes)
    delete [] nodes;
}

int mt_Cloud::getNodeType ()
{
  return mt_Node::CLOUD;
}

int mt_Cloud::getMaxNodes ()
{
  insist (this);
  return numNodes;
  exception: return 0;
}

mt_Node*mt_Cloud::getNode (int p)
{
  insist (this && nodes);
  insist (p >= 0 && p < numNodes);
  
  return nodes [p];
  exception: return 0;
}

int mt_Cloud::getOpposite (int p)
{
  insist (this && nodes);
  insist (p >= 0 && p < numNodes && nodes [p]);
  
  if (p == 0)
    return opposite;
  else
  {
    if (!nodes [p])
      return -1;
    
    insist (nodes [p]->isHost ());
    return 0;
  }

  exception: return -1;
}

void mt_Cloud::connect (int p, int o, mt_Node*n)
{
  insist (this && nodes);
  
  insist (p == 0 || o == 0);
  insist (p >= 0 && p < numNodes);
  insist (nodes);
  
  nodes [p] = n;
  if (p == 0)
    opposite = o;  

  exception:;
}

void mt_Cloud::disconnect (int p)
{
  insist (this && nodes);
  insist (p >= 0 && p < numNodes);

  nodes [p] = 0;
  if (p == 0)
    opposite = -1;

  exception:;
}
