/*
  mt_Calculator.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef mt_Calculator_h
#define mt_Calculator_h

#include <stdio.h>
#include "mt_Route.h"
#include "mt_Graph.h"
#include "mt_RouteFile.h"
#include "mt_Module.h"
#include "mt_HostTable.h"
#include "mt_Follower.h"

class mt_Calculator : public mt_Graph, public mt_Module
{
  private:

  class Link
  {
    public:
    mt_Node*other;
    int numLinks;
    int count;
  };
  
  enum
  {
    MAX_POSITIONS = 100
  };
  
  int writeRoutes (mt_RouteFile*routeFile);
  int makeLinks ();
  int numSections;
  int**sections;
  int maxPositions;
  int*positions;
  int growPositions ();
  Link*links;
  int getLinkPort (mt_Node*from, mt_Node*to);

  public:
  mt_Calculator ();
  ~mt_Calculator ();
  int writeRoutes (FILE*fp);
  int writeRoutes (char*filename);
  int getNumBytes (int from, int index);
  int getNumBytes (int from);
  virtual int getMaxRoutes () = 0;
  virtual int getNumRoutes (int from, int to) = 0;
  virtual int getNumRoutes (int from);
  
  int computeSections (mt_HostTable*hostTable, int sizePerHost, int sizePerRoute, int size);
  int getNumSections ();
  int getFirstSection (int from);
  int getNumSections (int from);
  int getSection (int from, int section, int*start, int*stop);

  virtual int initialize (char*mapFile);
  virtual int initialize (mt_Graph*graph, mt_Node*root);
  virtual void cleanup ();

  virtual int parseArgs (mt_Args*args) = 0;
  virtual void usage () = 0;

  virtual int getRoute (int from, int to, int routeIndex, mt_Route*route) = 0;
  int getSpreadRoute (int from, int to, int routeIndex, mt_Route*route);
};

extern mt_Calculator* mt_getCalculator ();

#endif /*mt_Calculator_h*/

