/*
  mt_Args.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <string.h>
#include <stdio.h>

#include "insist.h"
#include "mt_Args.h"
#include "mt_Tokenizer.h"

static char*typeStrings [mt_Args::NUM_TYPES] =
{
  "-route-args",
  "-simulator-args",
  "-simulation-args",
  "-mapper-args",
  "-job-args"
};


void mt_Args::usage ()
{
  char buffer [NUM_TYPES * 40];
  *buffer = 0;
  char*t = buffer;

  for (int i = 0; i < NUM_TYPES; i++)
    t += sprintf (t, "%s ... ", typeStrings [i]);
  
  printFormat ("arguments: %s", buffer);
}

mt_Args::mt_Args (int type, int argc)
{
  argv = 0;
  buffer = 0;
  
  insist (type >= 0 && type < NUM_TYPES);
  insist (argc > 0);
  
  this->type = type;
  this->argc = 0;
  this->maxArgc = argc;

  for (int i = 0; i < NUM_TYPES; i++)
  {
    argcs [i] = 0;
    argvs [i] = 0;
  }
  
  argv = new char* [argc];
  buffer = new char [argc * (MAX_ARGUMENT + 1)];
  
  insistp (argv, ("mt_Args::mt_Args: alloc failed."));
  insistp (buffer, ("mt_Args::mt_Args: alloc failed."));

  for (int i = 0; i < argc; i++)
    argv [i] = &buffer [i * (MAX_ARGUMENT + 1)];

  argvs [type] = argv;
  
  exception: return;
}

void mt_Args::addArg (char*s)
{
  insist (this);
  insist (type >= 0 && type < NUM_TYPES);
  insist (argc < maxArgc);
  insist (argv);
  insist (argv [argc]);
  insist (s && *s);
  
  strncpy (argv [argc++], s, MAX_ARGUMENT);
  argcs [type] = argc;
  
  exception: return;
}

void mt_Args::addArg (int n)
{
  insist (this);
  insist (type >= 0 && type < NUM_TYPES);
  insist (argc < maxArgc);
  insist (argv);
  insist (argv [argc]);
  
  sprintf (argv [argc++], "%d", n);
  argcs [type] = argc;
  
  exception: return;
}

mt_Args::~mt_Args ()
{
  if (buffer) delete [] buffer;
  if (argv) delete [] argv;
}

int mt_Args::parse (char*filename, int*maxLength, char**argv, char*buffer)
{
  mt_Tokenizer tokens (filename, " \t\n\r", MAX_LINE, ";");

  insist (maxLength && filename && *filename);
  
  int argc;
  argc = 0;
  char*s;
  char*t;
  t = buffer;
  *maxLength = 0;
  
  while ((s = tokens.getNext ()))
  {
    int len = (int) strlen (s);
    if (len > *maxLength)
      *maxLength = len;

    if (buffer)
    {
      insist (argv);
      argv [argc] = t;
      strcpy (argv [argc], s);
      t += len + 1;
    }
    argc++;
  }
  return argc;
  exception: return 0;
}

int mt_Args::fromFile (char*filename)
{
  buffer = 0;
  argv = 0;
  maxArgc = this->argc = 0;
  type = -1;

  for (int i = 0; i < NUM_TYPES; i++)
  {
    argcs [i] = 0;
    argvs [i] = 0;
  }
  
  insist (filename && *filename);
  
  int argc;
  int maxLength;
  maxLength = 0;

  argc = parse (filename, &maxLength, 0, 0);
  insist (argc && maxLength);
  
  argv = new char* [argc];
  buffer = new char [argc * (maxLength + 1)];
  
  insistp (argv, ("mt_Args::mt_Args: alloc failed."));
  insistp (buffer, ("mt_Args::mt_Args: alloc failed."));

  int c;
  c = parse (filename, &maxLength, argv, buffer);
  insist (c == argc);

  return fromArgs (argc, argv);
  
  exception: return 0;
}

mt_Args::mt_Args (int argc, char**argv)
{
  buffer = 0;
  this->argv = 0;
  this->maxArgc = this->argc = 0;
  type = -1;

  if (argc == 2)
    fromFile (argv[1]);
  else
    fromArgs (argc, argv);
}
    
int mt_Args::fromArgs (int argc, char**argv)
{
  insist (this);
  insist (argv);

  for (int i = 0; i < NUM_TYPES; i++)
  {
    argcs [i] = 0;
    argvs [i] = 0;
  }
  
  int n;
  n = 0;
  int pos [NUM_TYPES];
  int np;

  for (np = 0; np < NUM_TYPES; np++, n++)
  {
    if ((n = getNext (n, argc, argv)) == -1)
      break;
    pos [np] = n;
  }

  if (np == 0)
  {
    argvs [JOB] = &argv [1];
    argcs [JOB] = argc - 1;
  }
  
  for (int i = 0; i < np; i++)
  {
    int p = pos [i];
    
    int t = getType (argv [p]);
    insist (t >= 0 && t < NUM_TYPES);
    argvs [t] = &argv[p + 1];
    argcs [t] = i < np - 1 ? pos [i+1] - p - 1: argc - p - 1;
  }
  return 1;
  exception: return 0;
}


int mt_Args::getType (char*s)
{
  insist (this);
  insist (s && *s);

  for (int i = 0; i < NUM_TYPES; i++)
    if (!strcmp (s, typeStrings [i]))
      return i;
  exception :return -1;
}

int mt_Args::getNext (int offset, int argc, char**argv)
{
  insist (this);
  insist (argv);
  
  for (int i = offset; i < argc; i++)
    if (getType (argv[i]) != -1)
      return i;
    
  exception: return -1;
}

char**mt_Args::getArgs (int type, int*argc) const
{
  insist (this);
  insist (type >= 0 && type < NUM_TYPES);
  insist (argc);

  *argc = argcs [type];
  return argvs [type];
  
  exception: return 0;
}
