/*
  f_Host.c
  brute force route calculator
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#include <stdio.h>

#include "insist.h"
#include "f_Host.h"

int f_Host::getNodeType ()
{
  return mt_Node::HOST;
}

int f_Host::getMaxNodes ()
{
  return 1;
}

f_Host::f_Host (char*name, char*type) : f_Node (name, type)
{
  node = 0;
  opposite = -1;
}

void f_Host::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (!p);

  node = n;
  opposite = o;
  
  exception: return;
}

void f_Host::disconnect (int p)
{
  insist (this);
  insist (!p);

  node = 0;
  opposite = -1;
  
  exception: return;
}

mt_Node*f_Host::getNode (int p)
{
  insist (this);
  insist (!p);
  return node;
  exception: return 0;
}

int f_Host::getOpposite (int p)
{
  insist (this);
  insist (!p);
  return opposite;
  exception: return -1;
}
