/*
  f_Calculator.c
  brute force route calculator
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"

#include "mt_Queue.h"
#include "f_Calculator.h"

f_Calculator::f_Calculator()
{

}

f_Calculator::~f_Calculator()
{
  cleanup();
}

void f_Calculator::cleanup()
{
  int numHosts = getNumHosts();
  int split = 1;

  if (routes)
  {
    for (int i = 0; i < numHosts; i++)
      if (routes[i])
      {
	for (int j = 0; j < numHosts; j++)
	  if (routes[i][j])
	  {
	    for(int r = 0; r < split; r++)
	      if (routes [i] [j] [r])
		delete routes[i] [j] [r];
	    delete [] routes [i] [j];
	  }
	delete [] routes[i];
      }
    delete[] routes;
  }
  routes = 0;
}

int f_Calculator::initialize (mt_Graph*graph, mt_Node*root)
{
  return mt_Calculator::initialize (graph, root) && calculateRoutes ();
}

int f_Calculator::initialize (char *mapFile)
{
  return mt_Calculator::initialize (mapFile) &&
  calculateRoutes ();
}

int f_Calculator::checkForLoops(int src, int dst, char *bytes, int len)
{
  insist(src>=0 && src<getNumHosts());
  insist(dst>=0 && dst<getNumHosts());
  insist(bytes);
  insist(len>=1);

  printFormat("checkForLoops");

  if (src==4 && dst==2 && len==3)
    printFormat("ready");

  int *elist;
  elist = new int[len-1];
  insist(elist);

  f_Host *sourceHost;
  sourceHost = (f_Host *)getHost(src);
  insist(sourceHost);
  
  f_Node *n;
  n = (f_Node *)sourceHost->getNode(0);
  insist(n);

  int inPort;
  inPort = sourceHost->getOpposite(0);

  for(int h=0; h<len-1; h++)
  {
    insist(n->isSwitch());
    int outPort;
    outPort = inPort + bytes[h];
    elist[h] = ((f_Switch *)n)->edgeIndex[outPort];
    insist(elist[h]>=0);

    inPort = n->getOpposite(outPort);
    n = (f_Node *)n->getNode(outPort);    
  }
  
  // Check edge dependencies for loops

  int good;
  good = 1;

  int numChanges;
  numChanges = 0;

  for(int t=0; t<len-2 && good; t++)
  {
    int upper = elist[t];
    int lower = elist[t+1];

    if (edge[upper].table[lower] == f_Edge::UP)
    {
      good = 0;
      break;
    }
    else if (edge[upper].table[lower] == f_Edge::_NONE)
      numChanges++;

    for(int x=0; x<numEdges && good; x++)
      if (edge[x].table[upper] == f_Edge::DOWN)
	for(int y=0; y<numEdges && good; y++)
	  if (edge[lower].table[y] == f_Edge::DOWN)
	  {
	    // Check for loop
	    if (edge[x].table[y] == f_Edge::UP)
	    {
	      good = 0;
	      break;
	    }
	    else if (edge[x].table[y] == f_Edge::_NONE)
	      numChanges++;
	  }
  }

  if (!good)
  {
    printFormat("Loop check failed.");

    delete [] elist;
    return 0;
  }

  // No loop, so add edge dependencies

  int *change1, *change2;
  change1 = new int[numChanges];
  insist(change1);
  change2 = new int[numChanges];
  insist(change2);

  int change;
  change = 0;

  for(int t=0; t<len-2 && good; t++)
  {
    int upper = elist[t];
    int lower = elist[t+1];

    if (edge[upper].table[lower] == f_Edge::_NONE)
    {
      change1[change] = upper;
      change2[change] = lower;
      change++;
    }

    edge[upper].table[lower] = f_Edge::DOWN;
    edge[lower].table[upper] = f_Edge::UP;

    for(int x=0; x<numEdges && good; x++)
      if (edge[x].table[upper] == f_Edge::DOWN)
	for(int y=0; y<numEdges && good; y++)
	  if (edge[lower].table[y] == f_Edge::DOWN)
	  {
	    if (edge[x].table[y] == f_Edge::_NONE)
	    {
	      change1[change] = x;
	      change2[change] = y;
	      change++;
	    }
	    edge[x].table[y] = f_Edge::DOWN;
	    edge[y].table[x] = f_Edge::UP;
	  }
  }

  // add this route and find next route

  /*
  mt_Route *theRoute;
  theRoute = new mt_Route(bytes, len);
  if (!theRoute)
    return 0;
  routes[src][dst][0] = theRoute;
  */

  dst++;
  if (dst==getNumHosts())
  {
    dst = 0;
    src++;
  }
  if (src==getNumHosts())
  {
    delete [] change1;
    delete [] change2;
    return 1;
  }
  
  printFormat("Finding next route");

  if (findRoute(src, dst))
  {
    delete [] change1;
    delete [] change2;
    return 1;
  }
  else
  {
    // erase our tracks

    printFormat("Backing up");

    for(int c=0; c<numChanges; c++)
    {
      edge[change1[c]].table[change2[c]] = f_Edge::_NONE;
      edge[change2[c]].table[change1[c]] = f_Edge::_NONE;
    }

    delete [] change1;
    delete [] change2;
    return 0;
  }

  exception: return 0;
}

int globaldepth = 0;

int f_Calculator::explore(int src, int dst, char *bytes, int inPort,
			  int len, int maxDepth, f_Node *n)
{
  insist(src>=0 && src<getNumHosts());
  insist(dst>=0 && dst<getNumHosts());
  insist(bytes);
  insist(n);

  //  printFormat("explore %d",len);

  if (n->isHost())
  {
    if (n == getHost(dst))
      return checkForLoops(src, dst, bytes, len);
    else
      return 0;
  }

  f_Switch *s;

  s = (f_Switch *)n;
  if (s->found)
    return 0;

  if (len == maxDepth)
    return 0;

  s->found = 1;
  for(int p=0; p<f_Switch::NUM_PORTS; p++)
    if (p != inPort)
    {
      f_Node *next = (f_Node *)(s->getNode(p));
      if (next)
      {
	bytes[len] = p - inPort;
	int oppPort = s->getOpposite(p);

	globaldepth++;
	//	if (globaldepth%100 == 0)
	//	  printFormat("depth %d",globaldepth);

	if (explore(src,dst,bytes,oppPort,len+1,maxDepth,next))
	{
	  globaldepth--;
	  return 1;
	}
	globaldepth--;
      }
    }
  s->found = 0;

  exception:
  return 0;
}

int f_Calculator::findRoute(int src, int dst)
{
  char bytes[mt_Route::MAX_ROUTE];
  f_Switch *first;
  int inPort;

  printFormat("findRoute %d - %d",src,dst);

  for(int s=0; s<getNumSwitches(); s++)
    ((f_Switch *)getSwitch(s))->found = 0;
  
  first = (f_Switch *)(getHost(src)->getNode(0));
  first->found = 1;
  inPort = getHost(src)->getOpposite(0);

  for(int p=0; p<f_Switch::NUM_PORTS; p++)
  {
    f_Node *next = (f_Node *)first->getNode(p);
    if (next)
    {
      bytes[0] = p - inPort;
      int oppPort = first->getOpposite(p);
      
      for(int depth=1; depth<mt_Route::MAX_ROUTE; depth++)
	if (explore(src,dst,bytes,oppPort,1,depth,next))
	    return 1;
    }
  }
  return 0;
}

int f_Calculator::calculateRoutes()
{
  int s,d,r;
  int numHosts = getNumHosts();
  int numSwitches = getNumSwitches();
  int split = 1;

  routes = new mt_Route***[numHosts];
  if (!routes) return 0;
  for(s=0; s<numHosts; s++)
    routes[s] = 0;
  for(s=0; s<numHosts; s++)
  {
    routes[s] = new mt_Route**[numHosts];
    if (!routes[s]) return 0;
    for(d=0; d<numHosts; d++)
      routes[s][d] = 0;
    for(d=0; d<numHosts; d++)
    {
      routes[s][d] = new mt_Route*[split];
      if (!routes[s][d]) return 0;
      for(r=0; r<split; r++)
	routes[s][d][r] = 0;
    }
  }

  numEdges = 0;

  for(s=0; s<numSwitches; s++)
  {
    f_Switch *sw = (f_Switch *)getSwitch(s);

    for(int p=0; p<f_Switch::NUM_PORTS; p++)
    {
      f_Node *n = (f_Node *)sw->getNode(p);
      if (n && n->isSwitch())
	numEdges++;
    }
  }

  printFormat("numEdges: %d",numEdges);

  edge = new f_Edge[numEdges];

  int e;
  e = 0;

  for(s=0; s<numSwitches; s++)
  {
    f_Switch *sw = (f_Switch *)getSwitch(s);

    for(int p=0; p<f_Switch::NUM_PORTS; p++)
    {
      f_Node *n = (f_Node *)sw->getNode(p);
      if (n && n->isSwitch())
      {
	edge[e].index = e;
	edge[e].from = sw;
	edge[e].fromPort = p;
	edge[e].to = n;
	edge[e].toPort = sw->getOpposite(p);
	edge[e].table = new int[numEdges];
	for(int t=0; t<numEdges; t++)
	  edge[e].table[t] = f_Edge::_NONE;
	sw->edgeIndex[p] = e;
	e++;
      }
    }
  }

  return findRoute(0, 0);
}

mt_Node*f_Calculator::newNode (int nodeType, char*name, char*type)
{
  mt_Route r;
  
  insist (this);

  switch (nodeType)
  {
    case mt_Node::HOST:
      return new f_Host (name, type);
    case mt_Node::SWITCH:
      return new f_Switch (name, type);
    default:
      insist (0);
  }
  exception: return 0;
}

int f_Calculator::getNumRoutes (int from, int to)
{
  insist (this);
  insist (from >= 0 && from < getNumHosts ());
  insist (to >= 0 && to < getNumHosts ());

  return 1;

  exception: return 0;
}

int f_Calculator::getMaxRoutes ()
{
  insist (this);

  return 1;

  exception: return 0;
}

int f_Calculator::getRoute (int from, int to, int routeIndex, mt_Route*route)
{
  insist (this);
  insist (from >= 0 && from < getNumHosts ());
  insist (to >=0 && to < getNumHosts ());
  insist (route);
  insist (routes);
  insist (routes[from]);
  insist (routes[from][to]);
  insist (0 == routeIndex);
  insist (routes[from][to][routeIndex]);

  *route = *routes[from][to][routeIndex];
  
  return 1;
  exception: return 0;
}

void f_Calculator::usage ()
{
  printFormat
    (
     "route-args:\n"
     );
}

int f_Calculator::parseArgs (mt_Args*args)
{
  insist (args);
  
  int argc;  
  char**argv;
  argv = args->getArgs (mt_Args::CALCULATOR, &argc);
  
  for (int i = 0; i < argc; i++)
  {
    insist (argv[i]);

    printFormat ("f_Calculator: bad option \"%s\"", argv[i]);
    return 0;
  }

  return 1;
  exception: return 0;
}
