/*
  fc_Calculator.c
  simple calculator
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"

#include "mt_Host.h"
#include "mt_Switch.h"

#include "fc_Calculator.h"

fc_Calculator::fc_Calculator () : mt_Calculator ()
{
  routeTable = 0;
  *filename = 0;
}

fc_Calculator::~fc_Calculator ()
{
  if (routeTable)
    delete routeTable;
}

void fc_Calculator::cleanup ()
{
  if (routeTable)
    delete routeTable;
  routeTable = 0;
  mt_Calculator::cleanup ();
}

int fc_Calculator::initialize ()
{
  insist (*filename);
  insist (!routeTable);
  
  routeTable = new mt_RouteTable ();
  
  insistp (routeTable, ("fc_Calculator::initialize: alloc failed"));

  return routeTable->fromFile (filename, this);
  
  exception: return 0;
}

int fc_Calculator::initialize (mt_Graph*graph, mt_Node*root)
{
  insist (!routeTable);
  
  return mt_Calculator::initialize (graph, root) && initialize ();
  
  exception: return 0;
}

int fc_Calculator::initialize (char*mapFile)
{
  insist (mapFile && *mapFile);
  
  return mt_Calculator::initialize (mapFile) && initialize ();

  exception: return 0;
}

mt_Node*fc_Calculator::newNode (int nodeType, char*name, char*type)
{
  mt_Route r;
  
  insist (this);

  switch (nodeType)
  {
    case mt_Node::HOST:
      return new mt_Host (name, type);
    case mt_Node::SWITCH:
      return new mt_Switch (name, type);
    default:
      insist (0);
  }
  exception: return 0;
}

int fc_Calculator::getMaxRoutes ()
{
  insist (this);
  insist (routeTable);
  return routeTable->getMaxRoutes ();

  exception: return 0;
}

int fc_Calculator::getNumRoutes (int from, int to)
{
  insist (this);
  insist (routeTable);

  return routeTable->getNumRoutes (getHost(from)->getRouteIndex(), getHost(to)->getRouteIndex());

  exception: return 0;
}


int fc_Calculator::getRoute (int from, int to, int routeIndex, mt_Route*route)  
{
  insist (this);
  insist (routeTable);
  insist (route);
  
  return routeTable->getRoute (getHost(from)->getRouteIndex(), getHost(to)->getRouteIndex(), routeIndex, route);

  exception: return 0;
}

void fc_Calculator::usage ()
{
  printFormat
    (
     "route-args:\n"
     "-routes-file <filename>\n"
     );
}

int fc_Calculator::parseArgs (mt_Args*args)
{
  insist (args);
  
  int argc;  
  char**argv;
  argv = args->getArgs (mt_Args::CALCULATOR, &argc);
  
  for (int i = 0; i < argc; i++)
  {
    insist (argv[i]);
    
    if (!strcmp (argv [i], "-routes-file"))
    {
      if (++i == argc)
      {
	printFormat ("fc_Calculator::parseArgs: missing route file");
	return 0;
      }
      strncpy (filename, argv [i], mt_File::FILENAME_LENGTH);
    }
    else 
    {
      printFormat ("fc_Calculator::parseArgs:: bad option \"%s\"", argv[i]);
      return 0;
    }
  }
    
  if (!*filename)
  {
    printFormat ("fc_Calculator:parseArgs:: no route file");
    return 0;
  }
  
  return 1;
  exception: return 0;
}





