/*
  dj_Switch.h
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef dj_Switch_h
#define dj_Switch_h

#include "dj_Node.h"
#include "dj_QElement.h"

class dj_Switch : public dj_Node
{
  public:
  enum
  {
    NUM_PORTS = 16
  };
  
  int load [NUM_PORTS];
  int edgeNumber [NUM_PORTS];
  int subnet [NUM_PORTS];

  dj_QElement qElement [NUM_PORTS];

  private:
  mt_Node*nodes [NUM_PORTS];
  char opposites [NUM_PORTS];

  public:
  dj_Switch (char*name, char*type);
  
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void disconnect (int p);
  virtual int setOption (char*option, char*value);
};

#endif /*dj_Switch_h*/
