/*
  dj_Switch.c
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"
#include "dj_Switch.h"

dj_Switch::dj_Switch (char*name, char*type) : dj_Node (name, type)
{
  for (int i = 0; i < NUM_PORTS; i++)
  {
    nodes [i] = 0;
    opposites [i] = -1;
    edgeNumber [i] = -1;
  }
}

int dj_Switch::getNodeType ()
{
  return mt_Node::SWITCH;
}

int dj_Switch::getMaxNodes ()
{
  return NUM_PORTS;
}

int dj_Switch::setOption (char*option, char*value)
{
  if (!strcmp(option,"number"))
  {
    int n = atoi(value);
    if (n < 0)
      return 0;

    this->number = n;

    return 1;
  }
  else if (!strcmp(option,"edgenumbers"))
  {
    char *s = value;
    int p = 0;
    int num = 0;
    int neg = 0;
    int gotnum = 0;
    s--;
    while(*s)
    {
      s++;
      if (*s=='-')
	neg = 1;
      else if (*s>='0' && *s<='9')
      {
	num = 10*num + (*s - '0');
	gotnum = 1;
      }
      else if (gotnum)
      {
	if (neg)
	  num = -num;
	edgeNumber[p] = num;
	p++;
	num = 0;
	neg = 0;
	gotnum = 0;
      }
    }

    return 1;
  }
  else
  {
    return dj_Node::setOption(option,value);
  }
}

void dj_Switch::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = n;
  opposites [p] = o;
  
  exception: return;
}


void dj_Switch::disconnect (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = 0;
  opposites [p] = -1;
  
  exception: return;
}

mt_Node*dj_Switch::getNode (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return nodes [p];
  exception: return 0;
}


int dj_Switch::getOpposite (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return opposites [p];
  exception: return -1;
}
