/*
  dj_Host.h
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef dj_Host_h
#define dj_Host_h

#include "dj_Node.h"

class dj_Host : public dj_Node
{
  public:
  mt_Route *route;

  private:
  mt_Node*node;
  int opposite;
  
  public:
  dj_Host (char*name, char*type);
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void disconnect (int p);
};

#endif /*dj_Host_h*/
