/*
  bs_Simulation.h
  barrel simulation
  finucane@myri.com (David Finucane)
*/

#ifndef bs_Simulation_h
#define bs_Simulation_h

#include <stdio.h>

#include "mt_Simulation.h"
#include "mt_Job.h"
#include "mt_Network.h"

class bs_Job;

class bs_Simulation: public mt_Simulation
{
  private:
  int delay;
  int packetLength;  
  int traffic;
  
  friend class bs_Job;
  
  public:
  
  bs_Simulation();

  virtual mt_Job*newJob (mt_Node*node, mt_Network*network, mt_Calculator*calc);
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);

  void simpleDump(FILE *fp);
  void dump();
};


class bs_Job: public mt_Job
{
  private:
  bs_Simulation *sim;
  mt_Node**hosts;
  
  int numSends;
  int numReceives;
  int to;
  int me;
  int numHosts;
  int *sends;
  int *receives;
  int phase;
  
  void send ();
  void sendAfterDelay ();
  int getNeverSend (int i);
  int getNeverReceive (int i);
  int getNextDestination (int*to, int*delay);
  
  public:
  bs_Job (mt_Node*node, mt_Network*network, bs_Simulation*sim);
  virtual ~bs_Job ();

  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};

#endif /*bs_Simulation_h*/
