/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gm_rand_h_
#define _gm_rand_h_

/* A cheesy (but fast) pseudo-random number generator using the AAL
   (ATM Adaptation Layer) CRC-32 generator polynomial.  Will output
   all numbers in the range [0,2^{32}-2] before repeating. */

static inline unsigned
gmcp_rand (void)
{
  gm_assert (gm.rand_seed != 0);
  if ((int) gm.rand_seed < 0)
    gm.rand_seed = gm.rand_seed << 1 ^ 0x04C11DB7;
  else
    gm.rand_seed = gm.rand_seed << 1;
  return gm.rand_seed - 1;
}

/* Seed the random number generator. */

static inline void
gmcp_srand (int seed)
{
  gm.rand_seed = seed ? seed : -1;	/* seed must not be 0 */
}

/* Generate a random number in the range [0,a). */

static inline unsigned
gmcp_rand_mod (unsigned a)
{
  unsigned ret;
  unsigned mask;

  gm_assert (gm.rand_seed != 0);
  mask = (1 << gm_log2_roundup (a + 1)) - 1;
  do
    ret = gmcp_rand () & mask;
  while (ret > a);		/* < 1 retry needed, on average */
  return ret - 1;
}

/* ensure we don't accidentally use normal rand functions in the MCP */

#define gm_rand oops
#define gm_srand oops
#define gm_rand_mod oops

#endif /* _gm_rand_h_ defined */

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
