/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

struct foo
{
  unsigned int rand_seed;
};

struct foo gm = {-1};

#include "gm_rand.h"

#define TEST_MAX 0x10000

char test_hit[TEST_MAX / 8];

int
main ()
{
  int unset_bits = -1;
  int uncleared_bits = -1;

  /* Test that all bits are set and
     cleared at least some of the
     time. */
  while (unset_bits | uncleared_bits)
    {
      int r = gmcp_rand ();

      unset_bits &= ~r;
      uncleared_bits &= r;
    }

  /* Test that all the numbers in the
     range [1,TEST_MAX] are generated. */
  {
    int remaining;
    int r;

    for (remaining = TEST_MAX; remaining; remaining--)
      {
	do
	  r = gmcp_rand_mod (TEST_MAX);
	while (test_hit[r / 8] & (1 << (r & 7)));
	test_hit[r / 8] |= 1 << (r & 7);
      }
  }
  gm_printf ("Test passed.\n");
  return 0;
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
