/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: finucane@myri.com */

#include "gm_mappee.h"
#include "gm_bootstrap.h"

/*buffer for reply message*/
static struct
{
	char route[MCP_MAX_DEPTH];  
	McpReplyMessage m;
}reply;


/*********************************************************************/
/*this function replies to a scout message sent by the myrinet mapper
  mcp.  scout is the scout message, address is the node address of
  this lanai, mapVersion and mapAddress are version numbers of this
  node's current route table.  If there is no route table, these
  should be zero.  Returns zero if there was an error.*/
/*********************************************************************/	

int sendMcpReplyMessage(McpScoutMessage*scout, int address[2], int mapVersion, int mapAddress[2])
{	
	static int initialize = 1;
	int i;
	char*s;
	
	/*check things*/
	if (scout->type != MCP_HEADER_MAP_TYPE ||
	    scout->mtype != MCP_MAP_HEADER_SCOUT_TYPE ||
	    scout->from.length > MCP_MAX_DEPTH)
		return 0;

	/*initialize the part of the message that never changes*/
	if (initialize)
	{
		reply.m.type = MCP_HEADER_MAP_TYPE;
		reply.m.version = MCP_HEADER_VERSION;
		reply.m.length = sizeof(McpReplyMessage) - 8; /*does not include 8-byte header*/
		reply.m.mtype = MCP_MAP_HEADER_REPLY_TYPE;
 		reply.m.reply = MCP_REPLY_OK;
		reply.m.request = MCP_ROUTES_ONLY;
		reply.m.mapLevel = 0;
		reply.m.buffer[0] = 2; /* GM board type */
		initialize = 0;
	}

	/*set the part that changes*/

	reply.m.address[0] = address[0];
	reply.m.address[1] = address[1];
	reply.m.mapVersion = mapVersion;	
	reply.m.mapAddress[0] = mapAddress[0];
	reply.m.mapAddress[1] = mapAddress[1];
	reply.m.phase = scout->phase;
	reply.m.port = scout->port;
 	
	/*write the route in front of the message*/

	s = ((char*) &reply.m) - 1;
	for (i = scout->from.length - 1; i >= 0; i--,s--)
	{
		*s = (((char) scout->from.route[i]) & 0x3f) | 0x80;
	}
	
	/*correct start */
	if (scout->from.length == 0)
		s = (char*)& reply.m;
	else s++;
	
	/*send message*/
	SA = (int)s;
	SMP = s;
 	set_SMLT (&reply.m + 1);
 
	return 1;
}	
		
