/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gm_lanai_globals_h_
#define _gm_lanai_globals_h_

#include "gm_config.h"

#include "gm_types.h"
#include "gm_bootstrap.h"

/* Structure to ensure that the globals follow the event index. */

struct gm_packed_globals
{
  unsigned char event_index[BIGGEST_STATE_BIT << 1];
  gm_lanai_globals_t globals;
  char min_space_for_ports[(GM_NUM_PORTS
			    * GM_PAGE_LEN)
			   + GM_PAGE_HASH_PIECE_REF_TABLE_LEN];
};

extern struct gm_packed_globals _gmp;

/***********************************************************************
 * Finding GM LANai globals
 ***********************************************************************/

/* The "gm" structure includes most of the LANai globals, except those
   that are mapped into host memory.

   "GM" is an array of user-writable page-sized data structures
   associated with each port and mapped into host memory.


         ...
   |                       |
   |-----------------------|
   | GM_PORT(0)            |
   |-----------------------|
         ...
   |-----------------------|
   | GM_PORT(GM_NUM_PORTS) |
   |-----------------------|
   |                       |
   | Page hash piece       |
   |                       |
   +-----------------------+ (end of memory) */

#define GM_PORT (gm._PORT)
#define GM_PAGE_HASH_PIECE ((gm_dp_t *)&GM_PORT[GM_NUM_PORTS])

/****************
 * Globals in registers
 ****************/

#include "gm_enable_mcp_global_regs.h"

#if GM_ENABLE_MCP_GLOBAL_REGS

/* This causes compiler warnings, but the only way around that
   appears to be to modify the compiler. */

#define gm_event_index (_gmp.event_index)
register gm_lanai_globals_t *gmptr asm ("r11");
register unsigned int _GM_STATE asm ("r12");
register gm_connection_lp_t gm_connection asm ("r13");	/* 74 */
register gm_port_protected_lanai_side_lp_t gm_port asm ("r14");	/* 121 */

#define gm (*gmptr)
#define GM_STATE _GM_STATE

#else /* GM_ENABLE_MCP_GLOBAL_REGS */

#define gm_event_index (_gmp.event_index)
#define gmptr (&_gmp.globals)
#define gm (_gmp.globals)
#define GM_STATE gm.state
#define gm_connection gm.connection
#define gm_port (gm.port)

#endif /* GM_ENABLE_MCP_GLOBAL_REGS */

#include "gm_enable_trace.h"
/* register unsigned G_TRACEPTR asm("r18"); */
unsigned int G_TRACEPTR;

#endif /* _gm_lanai_globals_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
