/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file exists only to ensure that gm_fill_pte_from_host() is not
   inlined.  This function must not be inlined because    */

#include "gmcp.h"
#include "gm_debug_lanai_dma.h"
#include "gm_page_hash.h"
#include "gm_pte.h"

void
gm_fill_pte_from_host (gm_cached_pte_t * entry, unsigned int index)
{
  gm_dp_t piece;

  gm_assert (GM_POWER_OF_TWO (GM_ENTRIES_PER_PIECE));
  piece = GM_PAGE_HASH_PIECE[index / GM_ENTRIES_PER_PIECE];
  if (GM_DEBUG_LANAI_DMA && !piece)
    {
      GM_PANIC (("piece=0x%qx index=0x%x\n", (gm_u64_t) piece, index));
    }

  /* DMA the PTE */
  {
    gm_lp_t lar;
    gm_dp_t ear;

    lar = entry;
    gm_assert (GM_DMA_ALIGNED (lar));
    ear = piece + (sizeof (gm_pte_t) * (index % GM_ENTRIES_PER_PIECE));

    set_LAR (lar, GM_SDMA_DIR);
    set_EAR (ear, GM_SDMA_DIR);
    set_DMA_CTR (sizeof (gm_pte_t), GM_SDMA_DIR);
  }

  /* Wait for DMA to complete */
  while (!(get_ISR () & DMA_INT_BIT));

#if GM_ENABLE_GALVANTECH_WORKAROUND
  /* verify that the entry was not corrupted during the DMA. */
  {
    gm_u32_t computed_checksum;
    static int suppress_prints = 0;

    computed_checksum = gm_galvantech_PTE_checksum ((gm_pte_t *) entry);
    if (entry->pte.checksum != computed_checksum)
      {
	if (!suppress_prints)
	  {
	    gm_printf ("*** Galvantech memory error detected during SDMA.\n");
	    gm_hex_dump (entry, sizeof (gm_pte_t));
	    gm_printf ("computed=0x%08x read=0x%08x\n",
		       computed_checksum, entry->pte.checksum);
	    fflush (stdout);
	    fflush (stdout);
	    gm_always_assert (0);
	  }
	suppress_prints = 1;
	/* entry->port = -1; */
	continue;
      }
    suppress_prints = 0;
  }
#endif

  if (GM_DEBUG_PAGE_HASH || GM_DEBUG_PTES)
    {
      gm_printf (GM_STR ("PTE at index 0x%x fetched from host\n"), index);
      gm_pte_print (0, &entry->pte);
      gm_hex_dump (&entry->pte, sizeof (entry->pte));
    }
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
