/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#if L7 && !GM_FUNCTION_BASED_DISPATCH
#define FAIR(DO_INDEX,MY_INDEX,NEXT_STATE) do {				\
  asm volatile ("! vvvvvvvvvvvvvvvvvvvvvvvvvvvvv hand coded\n\t"	\
		"ld %0[%3],%?pc\n\t"					\
		"mov %2,%?rca\n\t"					\
		"st %?rca,%1[%3]\n\t"					\
		"nop\n\t"						\
		"nop\n\t"						\
		"! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ hand coded\n\t"	\
		: /* no output */					\
		: "n"(GM_OFFSETOF (gm_lanai_globals_t,			\
				   handler[DO_INDEX])),			\
		"n"(GM_OFFSETOF (gm_lanai_globals_t,			\
				 handler[MY_INDEX])),			\
		"i"(GM_REFERENCE_LABEL (NEXT_STATE)),			\
		"r"(gmptr)						\
		: "isr", "imr", "memory");				\
  /*  goto L_never_get_here; */						\
} while (0)
#endif

#ifndef FAIR
#define FAIR(DO_INDEX,MY_INDEX,NEXT_STATE) do {				\
  gm_handler_t handler = GET_HANDLER (DO_INDEX);			\
  SET_HANDLER (MY_INDEX, NEXT_STATE, );					\
  LOG_DISPATCH (1, "");							\
  GOTO_PREFETCHED_HANDLER (handler);					\
} while (0)
#endif


/***************************
** Fairness state machine **
***************************/

#ifdef POLL_PENDING

/************
 * sdma rdma
 ************/

MARK_LABEL (L_fair__sdma_rdma_0,)
{
  FAIR (START_SDMA_EVENT, FAIR_SDMA_RDMA_EVENT, L_fair__sdma_rdma_1);
}
GM_END_HANDLER;

MARK_LABEL (L_fair__sdma_rdma_1,)
{
  FAIR (START_RDMA_EVENT, FAIR_SDMA_RDMA_EVENT, L_fair__sdma_rdma_0);
}
GM_END_HANDLER;

#else /* ndef POLL_PENDING */

/************
 * sdma rdma
 ************/

MARK_LABEL (L_fair__sdma_rdma_0,)
{
  FAIR (START_SDMA_EVENT, FAIR_SDMA_RDMA_EVENT, L_fair__sdma_rdma_1);
}
GM_END_HANDLER;

MARK_LABEL (L_fair__sdma_rdma_1,)
{
  FAIR (START_RDMA_EVENT, FAIR_SDMA_RDMA_EVENT, L_fair__sdma_rdma_2);
}
GM_END_HANDLER;

MARK_LABEL (L_fair__sdma_rdma_2,)
{
  FAIR (POLL_EVENT, FAIR_SDMA_RDMA_EVENT, L_fair__sdma_rdma_0);
}
GM_END_HANDLER;

/************
 * sdma
 ************/

MARK_LABEL (L_fair__sdma_0,)
{
  FAIR (START_SDMA_EVENT, FAIR_SDMA_EVENT, L_fair__sdma_1);
}
GM_END_HANDLER;

MARK_LABEL (L_fair__sdma_1,)
{
  FAIR (POLL_EVENT, FAIR_SDMA_EVENT, L_fair__sdma_0);
}
GM_END_HANDLER;

/************
 * rdma
 ************/

MARK_LABEL (L_fair__rdma_0,)
{
  FAIR (START_RDMA_EVENT, FAIR_RDMA_EVENT, L_fair__rdma_1);
}
GM_END_HANDLER;

MARK_LABEL (L_fair__rdma_1,)
{
  FAIR (POLL_EVENT, FAIR_RDMA_EVENT, L_fair__rdma_0);
}
GM_END_HANDLER;

#endif /* ndef POLL_PENDING */

/****************
 * idle
 ****************/

_MARK_LABEL (L_idle,)
{
  DISPATCH (2, "");
}
GM_END_HANDLER;

/****************
 * never get here handler
 ****************/

#ifdef lanai7
MARK_LABEL (L_never_get_here,)
{
/* This HACK handler after dispatch asms to ensure that the compiler
   knows that all labels can be reached, despite the hand-coded
   lanai7 definition of DISPATCH(). */

  GOTO_PREFETCHED_HANDLER (gm.handler[RTC]);
}
GM_END_HANDLER;
#endif

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
