/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file contains external (i.e.: non-inline-able) error handlers
   so that error handling will not contend with the critical path for
   registers. */

#ifndef _gm_error_handlers_h_
#define _gm_error_handlers_h_

#include "gm_types.h"

void rdma_nack (int LZERO, int LONE);
void rdma_nack_down (int LZERO, int LONE);
void rdma_nack_reject (int LZERO, int LONE);
void rdma_nack_directed (int LZERO, int LONE);
void rdma_handle_out_of_sequence (int LZERO, int LONE);
void handle_send_error (gm_subport_t * sp, gm_status_t errno, int dest_id);
void handle_bad_send (gm_port_protected_lanai_side_t * port, gm_u8_t type,
		      void *event, unsigned int length);
void handle_bad_crc (const gm_packet_header_t * p,
		     unsigned int bytes_received);

#endif /* _gm_error_handlers_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
