/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1996, 1997, 1998, 1999, 2000 by Myricom, Inc.		 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_compiler.h"

/* Dispatch debug checks */

static inline void
check_state (gm_u32_t state)
{
  gm_assert (state < (BIGGEST_STATE_BIT << 1));
}

static inline void
check_handler (unsigned gm_offset)
{
  if (GM_DEBUG && (gm_offset & 3))
    {
      gm_printf ("Error (1): offset = 0x%x\n", gm_offset);
      fflush (stdout);
      gm_always_assert (0);
    }
  if (GM_DEBUG && (gm_offset < 16 || gm_offset >= 16 + NUM_EVENT_TYPES * 4))
    {
      gm_printf ("Error (2): offset = 0x%x\n", gm_offset);
      fflush (stdout);
      gm_always_assert (0);
    }
}

/* check for stack leaks */

#if !GM_DEBUG
#define check_ps(unique)
#else  /* GM_DEBUG */
#define check_ps(unique) do {						\
  char *fp;								\
  asm ("mov %?fp,%0\n\t" "nop\n\t" "nop":"=r" (fp));			\
  if (!gm.debug.old_fp)							\
    {									\
      gm.debug.old_fp = fp;						\
    }									\
  /* maybe this function is inlined */					\
  if (fp != gm.debug.old_fp)						\
    {									\
      gm_printf ("fp = %p, old_fp = %p\n", fp, gm.debug.old_fp);	\
      gm_printf ("unique = %d\n", (int) unique);			\
      fflush (stdout);							\
      gm_abort ();							\
    }									\
  gm_assert (fp >= (char *) gm_stack);					\
  gm_assert (fp <= (char *) gm_top_of_stack);				\
  gm_assert (gm.send_chunk[0].cafebabe == 0xcafebabe);			\
  gm_assert (gm.send_chunk[1].cafebabe == 0xcafebabe);			\
  gm_assert (gm.recv_chunk[0].cafebabe == 0xcafebabe);			\
  gm_assert (gm.recv_chunk[1].cafebabe == 0xcafebabe);			\
  gm_assert (gm_stack[0] == 0);						\
  gm_assert (gm_stack[1] == 0);						\
  gm_assert (gm_stack[2] == 0);						\
  gm_assert (gm_stack[3] == 0);						\
} while (0)
#endif /* GM_DEBUG */


#include "gm_dispatch_logging.h"


/****************
 * _DISPATCH()
 ****************/

/* This tiny pair of macros is actually a major HACK.  It requires
   that the _gm_event_index is just below the "gm" lanai globals
   structure with the entries in the table reversed so that they can
   be referenced by reverse-indexing off the "gm" pointer.
   Furthermore, the entries in this gm_event_index table must be
   computed using GM_SET_EVENT_INDEX_FOR_STATE (index, state) which
   stores the precomputed offset from "&gm" to the handler pointer to
   use, which furthermore requires that all the entries in the
   gm.handler table start no more than 255 bytes from the start of the
   gm structure.

   The point of all this is that it allows the ubiquitous "&gm"
   pointer that the compiler keeps in a register to be used to access
   these tables optimally efficiently, allowing for a 7-insn dispatch
   on the LANai4. */

extern unsigned char _gm_event_index[BIGGEST_STATE_BIT << 1];

static inline gm_u32_t
DISPATCH_OFFSET (gm_u32_t isr)
{
  gm_u32_t imr;

  /* We do not use the get_IMR() macro here, because we wish to avoid the
     extra safety barriers, and we know it is safe. --Glenn */

#if L4 | L5 | L6
  imr = IMR;
#elif L7 | L8 | L9
  imr = IMR_INIT_VAL;
#else
#error unrecognized LANai value
#endif

  return ((unsigned char *) ((gm_u32_t) gmptr - GM_STATE))[-((isr & imr))];
}

#if L7 && !GM_FUNCTION_BASED_DISPATCH
/* By hand coding this, we save 1 insn.  The L7 compiler does an
   optimal job on the rest of the dispatch. */

#if GM_ENABLE_TRACE
#define DISPATCH_TRACE_4_NOPS						\
                "and %%r18,%3,%%r18\n\t"				\
		"st %2,[%%r18++]\n\t"					\
		"st %1,[%%r18++]\n\t"					\
		"nop !end handcoded\n\t"
#define DISPATCH_TRACE_ARGS , "r" (RTC), "i" (GM_LANAI_TRACEMASK)
#else  /* !GM_ENABLE_TRACE */
#define DISPATCH_TRACE_4_NOPS						\
                "nop\n\t"						\
                "nop\n\t"						\
                "nop\n\t"						\
                "nop\n\t !end handcoded"
#define DISPATCH_TRACE_ARGS
#endif /* !GM_ENABLE_TRACE */

#define _DISPATCH(unique, msg, base_msg) do {				\
  gm_u32_t offset;                                                      \
									\
  log_it (unique, msg, LZERO, base_msg);				\
  check_ps (unique);							\
  check_state (GM_STATE);						\
  offset = DISPATCH_OFFSET(get_ISR());					\
  asm volatile ("ld [%0 add %1],%?pc ! begin hand coded\n\t"		\
		DISPATCH_TRACE_4_NOPS					\
		/* */ :							\
                /* */ : "r" (gmptr), "r" (offset) DISPATCH_TRACE_ARGS	\
                /* */ : "memory");					\
  goto L_never_get_here;						\
} while (0)

#endif /* L7 && !GM_FUNCTION_BASED_DISPATCH */

#ifndef _DISPATCH
#define _DISPATCH(unique, msg, base_msg) do {				\
  gm_u32_t _offset;							\
  log_it (unique, msg, LZERO, base_msg);				\
  check_ps (unique);							\
  _offset = DISPATCH_OFFSET(get_ISR());	                                \
  GM_LOG_EVT(_offset);							\
  check_handler(_offset);						\
  GOTO_HANDLER_AT_OFFSET (_offset);					\
} while (0)
#endif /* ndef _DISPATCH */

/* L7 function return:
	ld -4[%fp],%pc  			SKIP
	ld -8[%fp],%fp  			COMBINEv
	add %fp,0x0,%sp				COMBINE^ ld -8[fp],%sp
	nop
	nop
   L7 function call:	
	mov _check_handler,%pc
	mov .+8,%rca				SKIP
	st %rca,[--%sp]				SKIP
   L7 prologue:
	st %fp,-4[*%sp]	!push old FP		SKIP
	add %sp,8,%fp	!generate new FP 	ELIMINABLE???

	
	ld -4[%fp],%sp
	mov HANDLER,%pc
	nop 
	add %sp,8,%fp
*/

/****************
 * DISPATCH()
 ****************/

#if GM_DEBUG || GM_LOG_DISPATCHES
#define DISPATCH(unique, msg)						\
_DISPATCH (unique, __FILE__ ":" __GM_LINE__ ": " msg, msg)
#else
#define DISPATCH(unique, msg)						\
_DISPATCH (unique, 0, 0)
#endif

#ifndef INITIAL_DISPATCH
#define INITIAL_DISPATCH(a, b) DISPATCH (a, b)
#endif

/****************
 * GM_SET_EVENT_INDEX_FOR_STATE()
 ****************/

#define GM_SET_EVENT_INDEX_FOR_STATE(i,s) do {				\
  gm_assert (GM_OFFSETOF (gm_lanai_globals_t, handler[(i)]) <= 255);	\
  ((unsigned char *) gmptr)[-(s)]					\
    = GM_OFFSETOF (gm_lanai_globals_t, handler[(i)]);			\
} while (0)

/****************************************************************
 * Handler declarations
 ****************************************************************/

#if GM_FUNCTION_BASED_DISPATCH
gm_handler_t L_fair__rdma_0 ();
gm_handler_t L_fair__rdma_1 ();
gm_handler_t L_fair__sdma_0 ();
gm_handler_t L_fair__sdma_1 ();
gm_handler_t L_fair__sdma_rdma_0 ();
gm_handler_t L_fair__sdma_rdma_1 ();
gm_handler_t L_fair__sdma_rdma_2 ();
gm_handler_t L_idle ();
gm_handler_t L_rdma__chunk_done ();
gm_handler_t L_rdma__continue_chunk ();
gm_handler_t L_rdma__continue_last_chunk_0 ();
gm_handler_t L_rdma__continue_last_chunk_1 ();
gm_handler_t L_rdma__last_chunk_done_0 ();
gm_handler_t L_rdma__last_chunk_done_1 ();
gm_handler_t L_rdma__maybe_finish_ethernet_rdma ();
gm_handler_t L_rdma__rdma_chunk_0 ();
gm_handler_t L_rdma__rdma_chunk_1 ();
gm_handler_t L_rdma__token_done ();
gm_handler_t L_recv__discard_overflow_0 ();
gm_handler_t L_recv__discard_overflow_1 ();
gm_handler_t L_recv__done_discarding_overflow_0 ();
gm_handler_t L_recv__done_discarding_overflow_1 ();
gm_handler_t L_recv__got_chunk_0 ();
gm_handler_t L_recv__got_chunk_1 ();
gm_handler_t L_recv__start_receiving_chunk_0 ();
gm_handler_t L_recv__start_receiving_chunk_1 ();
gm_handler_t L_sdma__continue_sdma ();
gm_handler_t L_sdma__finish_ethernet_sdma ();
gm_handler_t L_sdma__finish_sdma ();
gm_handler_t L_sdma__poll_for_sdma_0 ();
gm_handler_t L_sdma__start_sdma_0 ();
gm_handler_t L_sdma__start_sdma_1 ();
gm_handler_t L_send__finish_sending_chunk ();
gm_handler_t L_send__start_sending_ack ();
gm_handler_t L_send__start_sending_chunk_0 ();
gm_handler_t L_send__start_sending_chunk_1 ();
gm_handler_t L_timer ();
gm_handler_t L_timer__update_host_sent_queues__rdma ();
gm_handler_t L_timer__update_host_sent_queues__sdma ();
#endif

