/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#if !defined lanai3 && !defined lanai7 && !defined lanai
#  error This file only works on the LANai
#endif

#include "gmcp.h"
#include "gm_types.h"
#include "gm_debug.h"
#include "gm_dispatch.h"

#include "gm_lanai_def.h"
#include "gm_bootstrap.h"
#include "gmcp.h"

int gm_debug_printing = GM_DEBUG;

#if GM_MIN_SUPPORTED_SRAM >= 512
				/* An ASCII to Morse Code conversion table.
				   "_": output a "dah"
				   ".": output a "dit"
				   " ": output a space
				   otherwise, substitute the Morse code for
				   the indicated ASCII char. */

char *gm_morse_table[128] = {
  "!",				/* NUL */
  "!",				/* SOH */
  "!",				/* STX */
  "!",				/* ETX */
  "!",				/* EOT */
  "!",				/* ENQ */
  "!",				/* ACK */
  "!",				/* BEL */
  "!",				/* BS */
  "!",				/* HT */
  "   ",			/* NL */
  "!",				/* VT */
  "!",				/* NP */
  "!",				/* CR */
  "!",				/* SO */
  "!",				/* SI */
  "!",				/* DLE */
  "!",				/* DC1 */
  "!",				/* DC2 */
  "!",				/* DC3 */
  "!",				/* DC4 */
  "!",				/* NAK */
  "!",				/* SYN */
  "!",				/* ETB */
  "!",				/* CAN */
  "!",				/* EM */
  "!",				/* SUB */
  "!",				/* ESC */
  "!",				/* FS */
  "!",				/* GS */
  "!",				/* RS */
  "!",				/* US */
  " ",				/* SP */
  "........",			/* ! */
  "!",				/* "" */
  "!",				/* # */
  "!",				/* $ */
  "!",				/* % */
  "!",				/* & */
  "!",				/* ' */
  "!",				/* ( */
  "!",				/* ) */
  "!",				/* * */
  "!",				/* + */
  "__..__",			/*   */
  "_...._",			/* - */
  "._._._",			/* . */
  "!",				/* / */
  "_____",			/* 0 */
  ".____",			/* 1 */
  "..___",			/* 2 */
  "...__",			/* 3 */
  "...._",			/* 4 */
  ".....",			/* 5 */
  "_....",			/* 6 */
  "__...",			/* 7 */
  "___..",			/* 8 */
  "____.",			/* 9 */
  "___...",			/* : */
  "!",				/* ; */
  "!",				/* < */
  "!",				/* = */
  "!",				/* > */
  "!",				/* ? */
  "!",				/* @ */
  "._",				/* A */
  "_...",			/* B */
  "_._.",			/* C */
  "_..",			/* D */
  ".",				/* E */
  ".._.",			/* F */
  "__.",			/* G */
  "....",			/* H */
  "..",				/* I */
  ".___",			/* J */
  "_._",			/* K */
  "._..",			/* L */
  "__",				/* M */
  "_.",				/* N */
  "___",			/* O */
  ".__.",			/* P */
  "__._",			/* Q */
  "._.",			/* R */
  "...",			/* S */
  "_",				/* T */
  ".._",			/* U */
  "..._",			/* V */
  ".__",			/* W */
  "_.._",			/* X */
  "_.__",			/* Y */
  "__..",			/* Z */
  "!",				/* [ */
  "!",				/* \ */
  "!",				/* ] */
  "!",				/* ^ */
  "!",				/* _ */
  "!",				/* ` */
  "A",				/* a */
  "B",				/* b */
  "C",				/* c */
  "D",				/* d */
  "E",				/* e */
  "F",				/* f */
  "G",				/* g */
  "H",				/* h */
  "I",				/* i */
  "J",				/* j */
  "K",				/* k */
  "L",				/* l */
  "M",				/* m */
  "N",				/* n */
  "O",				/* o */
  "P",				/* p */
  "Q",				/* q */
  "R",				/* r */
  "S",				/* s */
  "T",				/* t */
  "U",				/* u */
  "V",				/* v */
  "W",				/* w */
  "X",				/* x */
  "Y",				/* y */
  "Z",				/* z */
  "!",				/* { */
  "!",				/* | */
  "!",				/* } */
  "!",				/* ~ */
  "!",				/* DEL */
};


				/* Flash the STRING on LED in morse code. */
#define LED_ON 1
#define LED_OFF 0
#define DIT_TIME (400*1000)

unsigned int gm_morse_done = 1;

void
gm_morse_async (char *s)
{
  static char *string = "";
  static char *tokens = "";
  static int end_time = 0;
  static int led = LED_OFF;
  static enum
  { done, dash_or_dot, after_dash_or_dot, after_character }
  state = done;

  switch (state)
    {
    case done:
      /* Poll for new send. */
      if (s)
	{
	  gm_morse_done = 0;
	  string = s;
	  tokens = gm_morse_table[(int) *string];
	  goto start_token;
	}
      break;

    case dash_or_dot:
      if ((end_time - RTC) > 0)
	break;
      led = LED_OFF;
      set_LED (LED_OFF);
      state = after_dash_or_dot;
      end_time = RTC + DIT_TIME;
      break;

    case after_dash_or_dot:
      if ((end_time - RTC) > 0)
	break;

      tokens++;
      if (!*tokens)
	{
	  /* Finished dot or dash. */
	  led = LED_OFF;
	  set_LED (LED_OFF);
	  end_time = RTC + 2 * DIT_TIME;	/* Pause 2 more units. */
	  state = after_character;
	  break;
	}
      goto start_token;

    case after_character:
      if ((end_time - RTC) > 0)
	break;
      string++;
      if (!*string)
	{
	  state = done;
	  gm_morse_done = 1;
	  string = "";
	  return;
	}
      tokens = gm_morse_table[(int) *string];
    start_token:
      switch (*tokens)
	{
	default:
	  tokens = gm_morse_table[(int) *tokens];
	  goto start_token;
	case '.':
	  state = dash_or_dot;
	  led = LED_ON;
	  set_LED (LED_ON);
	  end_time = RTC + DIT_TIME;
	  return;
	case '_':
	  state = dash_or_dot;
	  led = LED_ON;
	  set_LED (LED_ON);
	  end_time = RTC + 3 * DIT_TIME;
	  return;
	case ' ':
	  state = dash_or_dot;
	  led = LED_OFF;
	  set_LED (LED_OFF);
	  end_time = RTC + 4 * DIT_TIME;
	  return;
	}
    }
}

void
gm_morse_sync (char *string)
{
  do
    gm_morse_async (string);
  while (!gm_morse_done);
}

#endif /* <= 512 */

GM_ENTRY_POINT void
_gm_assertion_failed (const char *assertion, int line, const char *file)
{
  fflush (stdout);

#define LZERO 0
  LOG_DISPATCH (0, "failed assertion");
#undef LZERO
  
  /* Wait for host to process any pending interrupt. */
  prepare_to_interrupt ("SOS\n");

  gm.interrupt.failed_assertion.text = (gm_lp_t) assertion;
  gm.interrupt.failed_assertion.line = line;
  gm.interrupt.failed_assertion.file = (gm_lp_t) file;
  gm_interrupt (GM_FAILED_ASSERTION_INTERRUPT);

  while (1)
    gm_morse_sync ("SOS\n");
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
