/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_bootstrap.h"

/****************************************************************
 * LANai hardware initialization.
 ****************************************************************/

void
gm_init_lanai_hardware (void)
{
  /* VERSION and/or WINDOW registers were set by the host. */

#if L4
  TIMEOUT = 3;			/* 4-second watchdog timeouts */
  MYRINET = CRC_ENABLE_BIT;	/* no NRES interrupts */
#elif L5
  TIMEOUT = 3;			/* 4-second watchdog timeouts */
  MYRINET = CRC8_ENABLE_BIT;
  BURST = 0;
#elif L6
  MYRINET = 0;
  /* Don't wait for LINK0_INT_BIT (link to come up) */
#elif L7
  ISR = PARITY_INT_BIT;
  TIMEOUT = 3;			/* 4 seconds, old-style link behaviour */
  MYRINET = (GM_ENABLE_CRC32 ? CRC32_ENABLE_BIT : 0);
#elif L8 
  ISR = PAR_INT_BIT;
  MYRINET = (GM_ENABLE_CRC32 ? CRC32_ENABLE_BIT : 0);
#elif L9
  ISR = PAR_INT_BIT;
  {
    gm_u32_t myrinet_bits = TIMEOUT0 | TIMEOUT1 | \
                WINDOW0  | WINDOW1  | \
                RX_CRC8_ENABLE_BIT | TX_CRC8_ENABLE_BIT;
    MYRINET = (GM_ENABLE_CRC32 ? CRC32_ENABLE_BIT | myrinet_bits : myrinet_bits);
  }
#else
#  error unrecognized LANai version.
#endif
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
