/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_debug.h"
#include "gm_struct_lock.h"

/* Report the region of memory that the client corrupted. */

void
__gm_struct_lock_report_client_corruption (char *where, void *start,
					   void *limit)
{
  GM_WARN (("GM client corrupted GM internal memory\n"));
  _GM_WARN (("   somewhere in the range [%p,%p).", start, limit));
  _GM_WARN (("   This error was detected in \"%s\".\n", where));
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
