/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_debug.h"

static char
gm_tolower(char c)
{
  if ((c>='A') && (c<='Z')) 
    {
      return c-'A'+'a';
    }
  return c;
}

GM_ENTRY_POINT 
int
gm_strncasecmp (const char *a, const char *b, int len)
{ 
  int result;

  gm_assert (a);
  gm_assert (b);
  while (len--)
    {   
      if (!*a || !*b)
        return gm_tolower(*a) - gm_tolower(*b);
      result = gm_tolower(*a++) - gm_tolower(*b++);
      if (result)
        return result;
    }
  return 0;
}

